/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.restlet.data.Request;
import org.sonatype.nexus.auth.ClientInfo;
import org.sonatype.nexus.auth.ClientInfoProvider;
import org.sonatype.nexus.rest.RemoteIPFinder;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class RestletClientInfoProvider
extends ComponentSupport
implements ClientInfoProvider {
    public ClientInfo getCurrentThreadClientInfo() {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && subject.getPrincipal() != null) {
            String userId = subject.getPrincipal().toString();
            Request current = Request.getCurrent();
            if (current != null) {
                String currentIp = RemoteIPFinder.findIP(current);
                String currentUa = current.getClientInfo().getAgent();
                return new ClientInfo(userId, currentIp, currentUa);
            }
            return null;
        }
        return null;
    }
}

