/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;

public class PathProtectionDescriptorBuilder {
    public static final String ANON = "anon";
    public static final String AUTHC = "authc";
    public static final String AUTHC_BASIC = "authcBasic";
    public static final String PERMS = "perms";
    public static final String ROLES = "roles";
    private String path;
    private Map<String, String> filters;

    public PathProtectionDescriptorBuilder path(String value) {
        this.path = (String)Preconditions.checkNotNull((Object)value);
        return this;
    }

    public PathProtectionDescriptorBuilder path(PlexusResource resource) {
        Preconditions.checkNotNull((Object)resource);
        return this.path(resource.getResourceUri());
    }

    public PathProtectionDescriptorBuilder filter(String name, String config) {
        Preconditions.checkNotNull((Object)name);
        if (this.filters == null) {
            this.filters = Maps.newLinkedHashMap();
        }
        this.filters.put(name, config);
        return this;
    }

    public PathProtectionDescriptorBuilder filter(String name) {
        return this.filter(name, null);
    }

    public PathProtectionDescriptorBuilder anon() {
        return this.filter(ANON);
    }

    public PathProtectionDescriptorBuilder authc() {
        return this.filter(AUTHC);
    }

    public PathProtectionDescriptorBuilder authcBasic() {
        return this.filter(AUTHC_BASIC);
    }

    public PathProtectionDescriptorBuilder perms(String ... names) {
        return this.filter(PERMS, this.join(names));
    }

    public PathProtectionDescriptorBuilder roles(String ... names) {
        return this.filter(ROLES, this.join(names));
    }

    private String join(String[] values) {
        Preconditions.checkNotNull((Object)values);
        Preconditions.checkArgument((values.length != 0 ? 1 : 0) != 0);
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            buff.append(values[i]);
            if (i + 1 >= values.length) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    public PathProtectionDescriptor build() {
        return new PathProtectionDescriptor(this.buildPathExpression(), this.buildFilterExpression());
    }

    private String buildPathExpression() {
        Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"Missing path");
        return this.path;
    }

    private String buildFilterExpression() {
        if (this.filters == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = this.filters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String name = entry.getKey();
            String config = entry.getValue();
            buff.append(name);
            if (config != null) {
                buff.append("[").append(config).append("]");
            }
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }
}

