/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.service.StatusService;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.plexus.rest.representation.VelocityRepresentation;

@Named
@Singleton
public class NexusStatusService
extends StatusService {
    private final ApplicationStatusSource applicationStatusSource;

    @Inject
    public NexusStatusService(ApplicationStatusSource applicationStatusSource) {
        this.applicationStatusSource = applicationStatusSource;
    }

    public Representation getRepresentation(Status status, Request request, Response response) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        SystemStatus systemStatus = this.applicationStatusSource.getSystemStatus();
        dataModel.put("request", request);
        dataModel.put("nexusVersion", systemStatus.getVersion());
        dataModel.put("nexusRoot", BaseUrlHolder.get());
        dataModel.put("statusCode", status.getCode());
        dataModel.put("statusName", status.getName());
        dataModel.put("errorDescription", StringEscapeUtils.escapeHtml((String)status.getDescription()));
        if (null != status.getThrowable()) {
            dataModel.put("errorStackTrace", StringEscapeUtils.escapeHtml((String)ExceptionUtils.getStackTrace((Throwable)status.getThrowable())));
        }
        VelocityRepresentation representation = new VelocityRepresentation(Context.getCurrent(), "/templates/errorPageContentHtml.vm", ((Object)((Object)this)).getClass().getClassLoader(), dataModel, MediaType.TEXT_HTML);
        return representation;
    }
}

