/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.plexus.rest.resource.RestletResource;

public class NexusRestletResource
extends RestletResource {
    public NexusRestletResource(Context context, Request request, Response response, PlexusResource delegate) {
        super(context, request, response, delegate);
    }

    public Representation represent(Variant variant) throws ResourceException {
        try {
            return super.represent(variant);
        }
        catch (ResourceException e) {
            Status status = e.getStatus();
            if (status == null) {
                this.handleError(e);
            } else {
                int code = status.getCode();
                if (Status.isServerError((int)code) && Status.SERVER_ERROR_SERVICE_UNAVAILABLE.getCode() != code) {
                    this.handleError(e);
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.handleError(e);
            throw e;
        }
    }

    public void acceptRepresentation(Representation representation) throws ResourceException {
        try {
            super.acceptRepresentation(representation);
        }
        catch (ResourceException e) {
            if (Status.isServerError((int)e.getStatus().getCode())) {
                this.handleError(e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.handleError(e);
            throw e;
        }
    }

    public void storeRepresentation(Representation representation) throws ResourceException {
        try {
            super.storeRepresentation(representation);
        }
        catch (ResourceException e) {
            if (Status.isServerError((int)e.getStatus().getCode())) {
                this.handleError(e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.handleError(e);
            throw e;
        }
    }

    public void removeRepresentations() throws ResourceException {
        try {
            super.removeRepresentations();
        }
        catch (ResourceException e) {
            if (Status.isServerError((int)e.getStatus().getCode())) {
                this.handleError(e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.handleError(e);
            throw e;
        }
    }

    protected void handleError(Throwable throwable) {
        this.logger.error(throwable.toString(), throwable);
    }
}

