/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.sonatype.nexus.configuration.application.GlobalRestApiSettings;
import org.sonatype.plexus.rest.DefaultReferenceFactory;

@Named
@Singleton
public class NexusReferenceFactory
extends DefaultReferenceFactory {
    private final GlobalRestApiSettings globalRestApiSettings;

    @Inject
    public NexusReferenceFactory(GlobalRestApiSettings globalRestApiSettings) {
        this.globalRestApiSettings = globalRestApiSettings;
    }

    public Reference getContextRoot(Request request) {
        Reference result = null;
        result = this.globalRestApiSettings.isEnabled() && this.globalRestApiSettings.isForceBaseUrl() && StringUtils.isNotEmpty((String)this.globalRestApiSettings.getBaseUrl()) ? new Reference(this.globalRestApiSettings.getBaseUrl()) : request.getRootRef().getParentRef().getParentRef();
        if (StringUtils.isEmpty((String)result.getPath())) {
            result.setPath("/");
        }
        return result;
    }

    private String getResourcePath(Request request) {
        String resourceUri;
        String path;
        String rootUri = request.getRootRef().getTargetRef().toString();
        if (!rootUri.endsWith("/")) {
            rootUri = rootUri + "/";
        }
        if ((path = (resourceUri = request.getResourceRef().getTargetRef().toString()).substring(rootUri.length())).startsWith("/")) {
            path = path.substring(1, path.length());
        }
        Preconditions.checkState((!path.startsWith("service/local") ? 1 : 0) != 0);
        return path;
    }

    public Reference createThisReference(Request request) {
        Reference rootRef = this.getContextRoot(request);
        Reference thisRef = new Reference(rootRef, "service/local/" + this.getResourcePath(request));
        return this.updateBaseRefPath(thisRef);
    }
}

