/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.XStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.util.AntPathMatcher;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.service.StatusService;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.rest.NexusPlexusResourceFinder;
import org.sonatype.nexus.rest.model.XStreamConfigurator;
import org.sonatype.plexus.rest.PlexusRestletApplicationBridge;
import org.sonatype.plexus.rest.RetargetableRestlet;
import org.sonatype.plexus.rest.resource.ManagedPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.web.ProtectedPathManager;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named(value="nexus")
@Singleton
public class NexusApplication
extends PlexusRestletApplicationBridge {
    private final EventBus eventBus;
    private final ProtectedPathManager protectedPathManager;
    private final ManagedPlexusResource statusPlexusResource;
    private final StatusService statusService;
    private final boolean useStrictChecking;
    private final AntPathMatcher shiroAntPathMatcher = new AntPathMatcher();

    @Inject
    public NexusApplication(EventBus eventBus, ProtectedPathManager protectedPathManager, @Named(value="StatusPlexusResource") ManagedPlexusResource statusPlexusResource, StatusService statusService) {
        this.eventBus = eventBus;
        this.protectedPathManager = protectedPathManager;
        this.statusPlexusResource = statusPlexusResource;
        this.statusService = statusService;
        this.useStrictChecking = System.getProperty("nexus.restlet.strict-uri-matching", "true").equals("true");
        LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "_UriMatching")).info("Strict URI matching: {}", (Object)this.useStrictChecking);
    }

    @VisibleForTesting
    public NexusApplication() {
        this(null, null, null, null);
    }

    @Subscribe
    public void onEvent(NexusStartedEvent evt) {
        this.recreateRoot(true);
        this.afterCreateRoot((RetargetableRestlet)this.getRoot());
    }

    @Subscribe
    public void onEvent(NexusStoppedEvent evt) {
        this.recreateRoot(false);
    }

    protected void doConfigure() {
        this.getRangeService().setEnabled(false);
        this.eventBus.register((Object)this);
    }

    public XStream doConfigureXstream(XStream xstream) {
        return XStreamConfigurator.configureXStream((XStream)xstream);
    }

    protected Router initializeRouter(Router root, boolean isStarted) {
        if (this.useStrictChecking) {
            root.setDefaultMatchQuery(false);
            root.setDefaultMatchingMode(2);
        }
        return root;
    }

    protected void doCreateRoot(Router root, boolean isStarted) {
        if (!isStarted) {
            return;
        }
        this.setStatusService(this.statusService);
        this.attach(this.getApplicationRouter(), (PlexusResource)this.statusPlexusResource);
        this.protectedPathManager.addProtectedResource("/service/local/**", "noSessionCreation,authcBasic,perms[nexus:permToCatchAllUnprotecteds]");
    }

    protected void attach(Router router, boolean strict, String uriPattern, Restlet target) {
        super.attach(router, this.useStrictChecking && strict, uriPattern, target);
    }

    protected void handlePlexusResourceSecurity(PlexusResource resource) {
        PathProtectionDescriptor descriptor = resource.getResourceProtection();
        if (descriptor == null) {
            return;
        }
        if (!this.shiroAntPathMatcher.match(descriptor.getPathPattern(), resource.getResourceUri())) {
            throw new IllegalStateException(String.format("Plexus resource %s would attach to URI=%s but protect path=%s that does not matches URI!", resource.getClass().getName(), resource.getResourceUri(), descriptor.getPathPattern()));
        }
        String filterExpression = descriptor.getFilterExpression();
        if (filterExpression != null && !filterExpression.contains("authcNxBasic")) {
            filterExpression = "noSessionCreation," + filterExpression;
        }
        this.protectedPathManager.addProtectedResource("/service/local" + descriptor.getPathPattern(), filterExpression);
    }

    protected void attach(Router router, PlexusResource resource) {
        this.handlePlexusResourceSecurity(resource);
        this.attach(router, resource.requireStrictChecking(), resource.getResourceUri(), (Restlet)new NexusPlexusResourceFinder(this.getContext(), resource));
    }
}

