/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.http.HttpRequest;
import com.noelios.restlet.http.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.subject.Subject;
import org.restlet.Context;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.restlet.util.Series;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageEOFException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.RemoteStorageTransportOverloadedException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStore;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageCompositeItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.item.uid.IsHiddenAttribute;
import org.sonatype.nexus.proxy.item.uid.IsRemotelyAccessibleAttribute;
import org.sonatype.nexus.proxy.repository.GroupItemNotFoundException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.ArtifactViewProvider;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.StorageFileItemRepresentation;
import org.sonatype.nexus.rest.StorageItemRepresentation;
import org.sonatype.nexus.rest.model.ContentListDescribeRequestResource;
import org.sonatype.nexus.rest.model.ContentListDescribeResource;
import org.sonatype.nexus.rest.model.ContentListDescribeResourceResponse;
import org.sonatype.nexus.rest.model.ContentListDescribeResponseResource;
import org.sonatype.nexus.rest.model.ContentListResource;
import org.sonatype.nexus.rest.model.ContentListResourceResponse;
import org.sonatype.nexus.rest.model.NotFoundReasoning;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.plexus.rest.representation.VelocityRepresentation;
import org.sonatype.security.SecuritySystem;

public abstract class AbstractResourceStoreContentPlexusResource
extends AbstractNexusPlexusResource {
    public static final String IS_DESCRIBE_PARAMETER = "describe";
    public static final String REQUEST_RECEIVED_KEY = "request.received.timestamp";
    public static final String OVERRIDE_FILENAME_KEY = "override-filename";
    private SecuritySystem securitySystem;
    private ApplicationStatusSource applicationStatusSource;
    public Map<String, ArtifactViewProvider> viewProviders;

    public AbstractResourceStoreContentPlexusResource() {
        this.setReadable(true);
        this.setModifiable(true);
    }

    @VisibleForTesting
    AbstractResourceStoreContentPlexusResource(SecuritySystem securitySystem, ApplicationStatusSource applicationStatusSource, Map<String, ArtifactViewProvider> viewProviders) {
        this.securitySystem = securitySystem;
        this.applicationStatusSource = applicationStatusSource;
        this.viewProviders = viewProviders;
    }

    @Inject
    public void setSecuritySystem(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }

    @Inject
    public void setApplicationStatusSource(ApplicationStatusSource applicationStatusSource) {
        this.applicationStatusSource = applicationStatusSource;
    }

    @Inject
    public void setViewProviders(Map<String, ArtifactViewProvider> viewProviders) {
        this.viewProviders = viewProviders;
    }

    public boolean acceptsUpload() {
        return true;
    }

    protected String getResourceStorePath(Request request) {
        try {
            String remainingPart = request.getResourceRef().getRemainingPart(false, false);
            String remainingDecodedPart = URLDecoder.decode(remainingPart.replace("+", "%2B"), "UTF-8").replace("%2B", "+");
            return this.parsePathFromUri(remainingDecodedPart);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Nexus cannot operate on platform not supporting UTF-8 character encoding!", e);
        }
    }

    protected boolean isDescribe(Request request) {
        return request.getResourceRef().getQueryAsForm().getFirst(IS_DESCRIBE_PARAMETER) != null;
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        try {
            ResourceStore store = this.getResourceStore(request);
            ResourceStoreRequest req = this.getResourceStoreRequest(request);
            try {
                StorageItem item = store.retrieveItem(req);
                return this.renderItem(context, request, response, variant, store, item);
            }
            catch (ItemNotFoundException e) {
                if (this.isDescribe(request)) {
                    return this.renderDescribeItem(context, request, response, variant, store, req, null, e);
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.handleException(request, response, e);
            return null;
        }
    }

    private void addNoCacheHeaders(Response response) {
        Series headers = ((HttpResponse)response).getHttpCall().getResponseHeaders();
        headers.add("Pragma", "no-cache");
        headers.add("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        headers.add("Cache-Control", "post-check=0, pre-check=0");
        headers.add("Expires", "0");
    }

    public Object upload(Context context, Request request, Response response, List<FileItem> files) throws ResourceException {
        MediaType mt;
        if (request.isEntityAvailable() && (mt = request.getEntity().getMediaType()) != null && MediaType.APPLICATION_WWW_FORM.isCompatible(mt)) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Content-type of \"" + mt.toString() + "\" is not acceptable for uploads!");
        }
        try {
            ResourceStoreRequest req = this.getResourceStoreRequest(request);
            for (FileItem fileItem : files) {
                this.getResourceStore(request).storeItem(req, fileItem.getInputStream(), null);
            }
        }
        catch (Exception t) {
            this.handleException(request, response, t);
        }
        return null;
    }

    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            ResourceStore store = this.getResourceStore(request);
            ResourceStoreRequest req = this.getResourceStoreRequest(request);
            store.deleteItem(req);
            this.getLogger().info("Storage item(s) on path \"" + req.getRequestPath() + "\" (and below) were deleted from repository [" + request.getAttributes().get("repositoryId") + "]");
        }
        catch (Exception e) {
            this.handleException(request, response, e);
        }
    }

    protected String parsePathFromUri(String parsedPath) {
        if (parsedPath.contains("?")) {
            parsedPath = parsedPath.substring(0, parsedPath.indexOf(63));
        }
        if (parsedPath.contains("#")) {
            parsedPath = parsedPath.substring(0, parsedPath.indexOf(35));
        }
        if (StringUtils.isEmpty((String)parsedPath)) {
            parsedPath = "/";
        }
        return parsedPath;
    }

    protected abstract ResourceStore getResourceStore(Request var1) throws NoSuchResourceStoreException, ResourceException;

    protected ResourceStoreRequest getResourceStoreRequest(Request request) {
        return this.getResourceStoreRequest(request, this.getResourceStorePath(request));
    }

    protected ResourceStoreRequest getResourceStoreRequest(Request request, String resourceStorePath) {
        Tag tag;
        ResourceStoreRequest result = new ResourceStoreRequest(resourceStorePath);
        this.getLogger().trace("Created ResourceStore request for {}", (Object)result.getRequestPath());
        result.setRequestLocalOnly(this.isLocal(request, resourceStorePath));
        result.setRequestRemoteOnly(this.isRemote(request, resourceStorePath));
        result.setRequestAsExpired(this.asExpired(request, resourceStorePath));
        result.setExternal(true);
        if (this.isDescribe(request)) {
            result.getRequestContext().put(REQUEST_RECEIVED_KEY, (Object)System.currentTimeMillis());
        }
        if (request.getConditions().getModifiedSince() != null) {
            result.setIfModifiedSince(request.getConditions().getModifiedSince().getTime());
        }
        if (request.getConditions().getNoneMatch() != null && request.getConditions().getNoneMatch().size() > 0 && (tag = (Tag)request.getConditions().getNoneMatch().get(0)) != null && tag.getName() != null) {
            result.setIfNoneMatch(tag.getName());
        }
        result.getRequestContext().put("request.address", (Object)this.getValidRemoteIPAddress(request));
        Subject subject = this.securitySystem.getSubject();
        if (subject != null && subject.getPrincipal() != null) {
            result.getRequestContext().put("request.user", (Object)subject.getPrincipal().toString());
        }
        result.getRequestContext().put("request.agent", (Object)request.getClientInfo().getAgent());
        if (request.isConfidential()) {
            result.getRequestContext().put("request.isConfidential", (Object)Boolean.TRUE);
            List certs = (List)request.getAttributes().get("org.restlet.https.clientCertificates");
            if (certs != null) {
                result.getRequestContext().put("request.certificates", (Object)certs);
            }
        }
        result.setRequestUrl(request.getOriginalRef().toString());
        return result;
    }

    protected Object renderItem(Context context, Request req, Response res, Variant variant, ResourceStore store, StorageItem item) throws IOException, AccessDeniedException, NoSuchResourceStoreException, IllegalOperationException, ItemNotFoundException, StorageException, ResourceException {
        if (this.isDescribe(req)) {
            return this.renderDescribeItem(context, req, res, variant, store, item.getResourceStoreRequest(), item, null);
        }
        if (!item.isVirtual() && !item.getRepositoryItemUid().getBooleanAttributeValue(IsRemotelyAccessibleAttribute.class)) {
            this.getLogger().debug(String.format("Request for remotely non-accessible UID %s is made and refused", item.getRepositoryItemUid().toString()));
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Resource is not found.");
        }
        if (item instanceof StorageFileItem) {
            return this.renderStorageFileItem(req, (StorageFileItem)item);
        }
        if (item instanceof StorageLinkItem) {
            return this.renderStorageLinkItem(context, req, res, variant, store, (StorageLinkItem)item);
        }
        if (item instanceof StorageCollectionItem) {
            return this.renderStorageCollectionItem(context, req, res, variant, store, (StorageCollectionItem)item);
        }
        return null;
    }

    @VisibleForTesting
    Object renderStorageCollectionItem(Context context, Request req, Response res, Variant variant, ResourceStore store, StorageCollectionItem coll) throws IOException, NoSuchResourceStoreException, IllegalOperationException, ItemNotFoundException, AccessDeniedException, ResourceException {
        String resPath = this.parsePathFromUri(req.getResourceRef().toString());
        if (!resPath.endsWith("/")) {
            res.redirectPermanent(this.createRedirectReference(req).getTargetRef().toString() + "/");
            return null;
        }
        this.addNoCacheHeaders(res);
        if (Method.HEAD.equals((Object)req.getMethod())) {
            return this.renderHeadResponseItem(context, req, res, variant, store, coll.getResourceStoreRequest(), coll);
        }
        Collection children = coll.list();
        ContentListResourceResponse response = new ContentListResourceResponse();
        ArrayList<String> uniqueNames = new ArrayList<String>(children.size());
        for (StorageItem child : children) {
            if (!child.isVirtual() && child.getRepositoryItemUid().getBooleanAttributeValue(IsHiddenAttribute.class) || uniqueNames.contains(child.getName())) continue;
            ContentListResource resource = new ContentListResource();
            resource.setText(child.getName());
            resource.setLeaf(!StorageCollectionItem.class.isAssignableFrom(child.getClass()));
            String uri = this.getResourceUri(req, resource, child);
            resource.setResourceURI(uri);
            resource.setRelativePath(child.getPath() + (resource.isLeaf() ? "" : "/"));
            resource.setLastModified(new Date(child.getModified()));
            resource.setSizeOnDisk(StorageFileItem.class.isAssignableFrom(child.getClass()) ? ((StorageFileItem)child).getLength() : -1L);
            response.addData(resource);
            uniqueNames.add(child.getName());
        }
        if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
            Representation result = this.serialize(context, req, variant, response);
            result.setModificationDate(new Date(coll.getModified()));
            return result;
        }
        return response;
    }

    @VisibleForTesting
    Object renderStorageLinkItem(Context context, Request req, Response res, Variant variant, ResourceStore store, StorageLinkItem item) throws ResourceException {
        try {
            return this.renderItem(context, req, res, variant, store, this.getRepositoryRouter().dereferenceLink(item));
        }
        catch (Exception e) {
            this.handleException(req, res, e);
            return null;
        }
    }

    @VisibleForTesting
    Representation renderStorageFileItem(Request req, StorageFileItem file) throws ResourceException {
        StorageFileItemRepresentation fileRepresentation = new StorageFileItemRepresentation(file);
        if (file.getResourceStoreRequest().getIfModifiedSince() != 0L && file.getModified() <= file.getResourceStoreRequest().getIfModifiedSince()) {
            throw new ResourceException(Status.REDIRECTION_NOT_MODIFIED, "Resource is not modified.");
        }
        if (file.getResourceStoreRequest().getIfNoneMatch() != null && fileRepresentation.getTag() != null && file.getResourceStoreRequest().getIfNoneMatch().equals(fileRepresentation.getTag().getName())) {
            throw new ResourceException(Status.REDIRECTION_NOT_MODIFIED, "Resource is not modified.");
        }
        return fileRepresentation;
    }

    private String getResourceUri(Request req, ContentListResource resource, StorageItem child) {
        Reference requestRoot;
        Reference root = this.getContextRoot(req);
        if (StringUtils.isBlank((String)root.getPath()) || !root.getPath().endsWith("/")) {
            root.setPath(StringUtils.defaultString((String)root.getPath(), (String)"") + "/");
        }
        if (StringUtils.isBlank((String)(requestRoot = req.getRootRef().getParentRef().getParentRef()).getPath()) || !requestRoot.getPath().endsWith("/")) {
            requestRoot.setPath(StringUtils.defaultString((String)requestRoot.getPath(), (String)"") + "/");
        }
        Reference ref = req.getResourceRef().getTargetRef();
        String uri = ref.toString();
        if (ref.getQuery() != null) {
            uri = uri.substring(0, uri.length() - ref.getQuery().length() - 1);
        }
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + child.getName();
        if (!resource.isLeaf()) {
            uri = uri + "/";
        }
        if (root == requestRoot || root.equals((Object)requestRoot)) {
            return uri;
        }
        return uri.replace(requestRoot.toString(), root.toString());
    }

    protected Representation serialize(Context context, Request req, Variant variant, Object payload) throws IOException {
        if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            dataModel.put("listItems", this.sortContentListResource(((ContentListResourceResponse)payload).getData()));
            dataModel.put("request", req);
            dataModel.put("nexusVersion", this.applicationStatusSource.getSystemStatus().getVersion());
            dataModel.put("nexusRoot", BaseUrlHolder.get());
            VelocityRepresentation representation = new VelocityRepresentation(context, "/templates/repositoryContentHtml.vm", ((Object)((Object)this)).getClass().getClassLoader(), dataModel, variant.getMediaType());
            return representation;
        }
        return null;
    }

    protected Object renderHeadResponseItem(Context context, Request req, Response res, Variant variant, ResourceStore store, ResourceStoreRequest request, StorageCollectionItem coll) throws IOException, AccessDeniedException, NoSuchResourceStoreException, IllegalOperationException, ItemNotFoundException, StorageException, ResourceException {
        return new StorageItemRepresentation(variant.getMediaType(), (StorageItem)coll);
    }

    protected Object renderDescribeItem(Context context, Request req, Response res, Variant variant, ResourceStore store, ResourceStoreRequest request, StorageItem item, Throwable t) throws IOException, AccessDeniedException, NoSuchResourceStoreException, IllegalOperationException, ItemNotFoundException, StorageException, ResourceException {
        Parameter describeParameter = req.getResourceRef().getQueryAsForm().getFirst(IS_DESCRIBE_PARAMETER);
        if (StringUtils.isNotEmpty((String)describeParameter.getValue())) {
            String key = describeParameter.getValue();
            if (!this.viewProviders.containsKey(key)) {
                throw new IllegalRequestException(request, "No view for key: " + key);
            }
            Object result = this.viewProviders.get(key).retrieveView(store, request, item, req);
            if (result == null) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor((ResourceStoreRequest)request, (String)"View provider keyed \"%s\" did not provide content.", (Object[])new Object[]{key}));
            }
            return result;
        }
        ContentListDescribeResourceResponse result = new ContentListDescribeResourceResponse();
        ContentListDescribeResource resource = new ContentListDescribeResource();
        resource.setRequestUrl(req.getOriginalRef().toString());
        if (request.getRequestContext().containsKey((Object)REQUEST_RECEIVED_KEY)) {
            long received = (Long)request.getRequestContext().get((Object)REQUEST_RECEIVED_KEY);
            resource.setProcessingTimeMillis(System.currentTimeMillis() - received);
        } else {
            resource.setProcessingTimeMillis(-1L);
        }
        resource.setRequest(this.describeRequest(context, req, res, variant, request));
        resource.setResponse(this.describeResponse(context, req, res, variant, request, item, t));
        result.setData(resource);
        return result;
    }

    protected ContentListDescribeRequestResource describeRequest(Context context, Request req, Response res, Variant variant, ResourceStoreRequest request) {
        ContentListDescribeRequestResource result = new ContentListDescribeRequestResource();
        result.setRequestUrl(request.getRequestUrl());
        result.setRequestPath(request.getRequestPath());
        for (Map.Entry entry : request.getRequestContext().flatten().entrySet()) {
            result.addRequestContext(entry.toString());
        }
        return result;
    }

    protected NotFoundReasoning buildNotFoundReasoning(Repository repository, Throwable t) {
        NotFoundReasoning reasoning = new NotFoundReasoning();
        reasoning.setReasonMessage(t.getMessage());
        reasoning.setThrowableType(t.getClass().getName());
        if (repository != null) {
            reasoning.setRepositoryId(repository.getId());
        }
        if (t instanceof GroupItemNotFoundException) {
            GroupItemNotFoundException ginf = (GroupItemNotFoundException)t;
            reasoning.setRepositoryId(ginf.getReason().getRepository().getId());
            for (Map.Entry r : ginf.getMemberReasons().entrySet()) {
                reasoning.addNotFoundReasoning(this.buildNotFoundReasoning((Repository)r.getKey(), (Throwable)r.getValue()));
            }
        }
        return reasoning;
    }

    protected ContentListDescribeResponseResource describeResponse(Context context, Request req, Response res, Variant variant, ResourceStoreRequest request, StorageItem item, Throwable e) {
        ContentListDescribeResponseResource result = new ContentListDescribeResponseResource();
        result.getProcessedRepositoriesList().addAll(request.getProcessedRepositories());
        for (Map.Entry entry : request.getAppliedMappings().entrySet()) {
            result.addAppliedMapping((String)entry.getKey() + " repository applied " + entry.getValue());
        }
        if (item == null) {
            result.setResponseType("NOT_FOUND");
            if (e != null) {
                result.addNotFoundReasoning(this.buildNotFoundReasoning(null, e));
            }
            return result;
        }
        if (item instanceof StorageFileItem) {
            result.setResponseType("FILE");
        } else if (item instanceof StorageCollectionItem) {
            result.setResponseType("COLL");
        } else if (item instanceof StorageLinkItem) {
            result.setResponseType("LINK");
        } else {
            result.setResponseType(item.getClass().getName());
        }
        result.setResponseActualClass(item.getClass().getName());
        result.setResponsePath(item.getPath());
        if (!item.isVirtual()) {
            result.setResponseUid(item.getRepositoryItemUid().toString());
            result.setOriginatingRepositoryId(item.getRepositoryItemUid().getRepository().getId());
            result.setOriginatingRepositoryName(item.getRepositoryItemUid().getRepository().getName());
            result.setOriginatingRepositoryMainFacet(item.getRepositoryItemUid().getRepository().getRepositoryKind().getMainFacet().getName());
        } else {
            result.setResponseUid("virtual");
        }
        result.addProperty("created=" + item.getCreated());
        result.addProperty("modified=" + item.getModified());
        result.addProperty("lastRequested=" + item.getLastRequested());
        result.addProperty("remoteChecked=" + item.getRemoteChecked());
        result.addProperty("remoteUrl=" + item.getRemoteUrl());
        result.addProperty("storedLocally=" + item.getStoredLocally());
        result.addProperty("isExpired=" + item.isExpired());
        result.addProperty("readable=" + item.isReadable());
        result.addProperty("writable=" + item.isWritable());
        result.addProperty("virtual=" + item.isVirtual());
        TreeMap sortedAttributes = Maps.newTreeMap();
        sortedAttributes.putAll(item.getRepositoryItemAttributes().asMap());
        for (Map.Entry entry : sortedAttributes.entrySet()) {
            result.addAttribute(entry.toString());
        }
        if (item instanceof StorageCompositeItem) {
            StorageCompositeItem storageCompositeItem = (StorageCompositeItem)item;
            for (StorageItem source : storageCompositeItem.getSources()) {
                if (!source.isVirtual()) {
                    result.addSource(source.getRepositoryItemUid().toString());
                    continue;
                }
                result.addSource(source.getPath());
            }
        }
        return result;
    }

    private List<ContentListResource> sortContentListResource(Collection<ContentListResource> list) {
        ArrayList<ContentListResource> result = new ArrayList<ContentListResource>(list);
        Collections.sort(result, new Comparator<ContentListResource>(){

            @Override
            public int compare(ContentListResource o1, ContentListResource o2) {
                if (!o1.isLeaf()) {
                    if (!o2.isLeaf()) {
                        return o1.getText().compareTo(o2.getText());
                    }
                    return 1;
                }
                if (!o2.isLeaf()) {
                    return -1;
                }
                return o1.getText().compareTo(o2.getText());
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleException(Request req, Response res, Exception t) throws ResourceException {
        block19: {
            boolean shouldLogInfoStackTrace = false;
            try {
                if (t instanceof ResourceException) {
                    throw (ResourceException)((Object)t);
                }
                if (t instanceof LocalStorageEOFException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_NOT_FOUND, t), (Throwable)t);
                }
                if (t instanceof IllegalArgumentException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_BAD_REQUEST, t), (Throwable)t);
                }
                if (t instanceof RemoteStorageTransportOverloadedException) {
                    throw new ResourceException(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, (Throwable)t);
                }
                if (t instanceof RepositoryNotAvailableException) {
                    throw new ResourceException(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, (Throwable)t);
                }
                if (t instanceof IllegalRequestException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_BAD_REQUEST, t), (Throwable)t);
                }
                if (t instanceof IllegalOperationException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_BAD_REQUEST, t), (Throwable)t);
                }
                if (t instanceof UnsupportedStorageOperationException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_BAD_REQUEST, t), (Throwable)t);
                }
                if (t instanceof NoSuchRepositoryAccessException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_FORBIDDEN, t), (Throwable)t);
                }
                if (t instanceof NoSuchRepositoryException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_NOT_FOUND, t), (Throwable)t);
                }
                if (t instanceof NoSuchResourceStoreException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_NOT_FOUND, t), (Throwable)t);
                }
                if (t instanceof ItemNotFoundException) {
                    throw new ResourceException(this.getStatus(Status.CLIENT_ERROR_NOT_FOUND, t), (Throwable)t);
                }
                if (t instanceof AccessDeniedException) {
                    AbstractResourceStoreContentPlexusResource.challengeIfNeeded(req, res, (AccessDeniedException)((Object)t));
                    break block19;
                }
                shouldLogInfoStackTrace = true;
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)t);
            }
            finally {
                if (t instanceof ResourceException) {
                    ResourceException re = (ResourceException)((Object)t);
                    if (re.getStatus() == null || re.getStatus().isError()) {
                        this.handleErrorConstructLogMessage(req, res, t, shouldLogInfoStackTrace);
                    }
                } else {
                    this.handleErrorConstructLogMessage(req, res, t, shouldLogInfoStackTrace);
                }
            }
        }
    }

    private Status getStatus(Status status, Exception e) {
        if (e == null || e.getMessage() == null) {
            return status;
        }
        return new Status(status, e.getMessage());
    }

    protected void handleErrorConstructLogMessage(Request req, Response res, Exception t, boolean shouldLogInfoStackTrace) {
        String message = "Got exception during processing request \"" + req.getMethod() + " " + req.getResourceRef().toString() + "\": ";
        if (t instanceof NoSuchRepositoryException || t instanceof AccessDeniedException) {
            this.getLogger().debug(message, (Throwable)t);
        } else if (this.getLogger().isDebugEnabled()) {
            if (t instanceof ItemNotFoundException) {
                this.getLogger().error(message + t.getMessage());
            } else {
                this.getLogger().error(message, (Throwable)t);
            }
        } else if (!(t instanceof ItemNotFoundException) && !(t instanceof IllegalRequestException) || shouldLogInfoStackTrace) {
            if (shouldLogInfoStackTrace) {
                this.getLogger().error(message, (Throwable)t);
            } else {
                this.getLogger().error(message + t.getMessage());
            }
        }
    }

    public static void challengeIfNeeded(Request req, Response res, AccessDeniedException t) {
        HttpServletRequest servletRequest = ((ServletCall)((HttpRequest)req).getHttpCall()).getRequest();
        String scheme = (String)servletRequest.getAttribute("auth.scheme");
        ChallengeScheme challengeScheme = null;
        challengeScheme = "NxBASIC".equals(scheme) ? new ChallengeScheme("HTTP_NXBASIC", "NxBasic", "Fake basic HTTP authentication") : ChallengeScheme.HTTP_BASIC;
        String realm = (String)servletRequest.getAttribute("auth.realm");
        if (servletRequest.getAttribute("nexus.anonymous") != null) {
            res.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        } else {
            res.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        }
        res.getChallengeRequests().add(new ChallengeRequest(challengeScheme, realm));
    }
}

