/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringEscapeUtils;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.router.RepositoryRouter;
import org.sonatype.nexus.rest.RemoteIPFinder;
import org.sonatype.nexus.templates.NoSuchTemplateIdException;
import org.sonatype.nexus.templates.TemplateManager;
import org.sonatype.nexus.templates.TemplateSet;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;
import org.sonatype.plexus.rest.ReferenceFactory;
import org.sonatype.plexus.rest.resource.AbstractPlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorMessage;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;

public abstract class AbstractNexusPlexusResource
extends AbstractPlexusResource
implements PlexusResource {
    public static final String PASSWORD_PLACE_HOLDER = "|$|N|E|X|U|S|$|";
    public static final String IS_LOCAL_PARAMETER = "isLocal";
    public static final String IS_REMOTE_PARAMETER = "isRemote";
    public static final String AS_EXPIRED_PARAMETER = "asExpired";
    private NexusConfiguration nexusConfiguration;
    private RepositoryRegistry repositoryRegistry;
    private RepositoryRegistry defaultRepositoryRegistry;
    private ReferenceFactory referenceFactory;
    private TemplateManager templateManager;
    private RepositoryRouter repositoryRouter;

    @Inject
    public void setNexusConfiguration(NexusConfiguration nexusConfiguration) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
    }

    @Inject
    public void setRepositoryRegistry(@Named(value="protected") RepositoryRegistry repositoryRegistry) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    @Inject
    public void setDefaultRepositoryRegistry(@Named(value="default") RepositoryRegistry repositoryRegistry) {
        this.defaultRepositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    @Inject
    public void setReferenceFactory(ReferenceFactory referenceFactory) {
        this.referenceFactory = (ReferenceFactory)Preconditions.checkNotNull((Object)referenceFactory);
    }

    @Inject
    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = (TemplateManager)Preconditions.checkNotNull((Object)templateManager);
    }

    @Inject
    public void setRepositoryRouter(RepositoryRouter repositoryRouter) {
        this.repositoryRouter = (RepositoryRouter)Preconditions.checkNotNull((Object)repositoryRouter);
    }

    protected NexusConfiguration getNexusConfiguration() {
        return this.nexusConfiguration;
    }

    protected RepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    protected RepositoryRegistry getUnprotectedRepositoryRegistry() {
        return this.defaultRepositoryRegistry;
    }

    protected TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    protected RepositoryRouter getRepositoryRouter() {
        return this.repositoryRouter;
    }

    protected TemplateSet getRepositoryTemplates() {
        return this.getTemplateManager().getTemplates().getTemplates(RepositoryTemplate.class);
    }

    protected RepositoryTemplate getRepositoryTemplateById(String id) throws NoSuchTemplateIdException {
        return (RepositoryTemplate)this.getTemplateManager().getTemplate(RepositoryTemplate.class, id);
    }

    protected Reference getContextRoot(Request request) {
        return this.referenceFactory.getContextRoot(request);
    }

    protected boolean isLocal(Request request, String resourceStorePath) {
        boolean isLocal;
        boolean bl = isLocal = request.getResourceRef().getQueryAsForm().getFirst(IS_LOCAL_PARAMETER) != null;
        if (resourceStorePath != null) {
            isLocal = isLocal || resourceStorePath.endsWith("/");
        }
        return isLocal;
    }

    protected boolean isRemote(Request request, String resourceStorePath) {
        return request.getResourceRef().getQueryAsForm().getFirst(IS_REMOTE_PARAMETER) != null;
    }

    protected boolean asExpired(Request request, String resourceStorePath) {
        return request.getResourceRef().getQueryAsForm().getFirst(AS_EXPIRED_PARAMETER) != null;
    }

    private Reference updateBaseRefPath(Reference reference) {
        if (reference.getBaseRef().getPath() == null) {
            reference.getBaseRef().setPath("/");
        } else if (!reference.getBaseRef().getPath().endsWith("/")) {
            reference.getBaseRef().setPath(reference.getBaseRef().getPath() + "/");
        }
        return reference;
    }

    protected Reference createReference(Reference base, String relPart) {
        Reference ref = new Reference(base, relPart);
        return this.updateBaseRefPath(ref).getTargetRef();
    }

    protected Reference createChildReference(Request request, PlexusResource resource, String childPath) {
        return this.referenceFactory.createChildReference(request, childPath);
    }

    protected Reference createRootReference(Request request, String relPart) {
        Reference ref = new Reference(this.getContextRoot(request), relPart);
        if (!ref.getBaseRef().getPath().endsWith("/")) {
            ref.getBaseRef().setPath(ref.getBaseRef().getPath() + "/");
        }
        return ref.getTargetRef();
    }

    protected Reference createRepositoryReference(Request request, String repoId) {
        return this.createReference(this.getContextRoot(request), "service/local/repositories/" + repoId).getTargetRef();
    }

    protected Reference createRepositoryReference(Request request, String repoId, String repoPath) {
        Reference repoRootRef = this.createRepositoryReference(request, repoId);
        if (repoPath.startsWith("/")) {
            repoPath = repoPath.substring(1);
        }
        repoPath = "content/" + repoPath;
        return this.createReference(repoRootRef, repoPath);
    }

    protected Reference createRepositoryGroupReference(Request request, String groupId) {
        return this.createReference(this.getContextRoot(request), "service/local/repo_groups/" + groupId).getTargetRef();
    }

    protected Reference createRedirectReference(Request request) {
        String uriPart = request.getResourceRef().getTargetRef().toString().substring(this.getContextRoot(request).getTargetRef().toString().length());
        if (uriPart.startsWith("/")) {
            uriPart = uriPart.substring(1);
        }
        return this.updateBaseRefPath(new Reference(this.getContextRoot(request), uriPart)).getTargetRef();
    }

    protected ErrorResponse getNexusErrorResponse(String id, String msg) {
        ErrorResponse ner = new ErrorResponse();
        ErrorMessage ne = new ErrorMessage();
        ne.setId(id);
        ne.setMsg(StringEscapeUtils.escapeHtml((String)msg));
        ner.addError(ne);
        return ner;
    }

    protected void handleInvalidConfigurationException(InvalidConfigurationException e) throws PlexusResourceException {
        ErrorResponse nexusErrorResponse;
        this.getLogger().debug("Configuration error!", (Throwable)e);
        ValidationResponse vr = e.getValidationResponse();
        if (vr != null && vr.getValidationErrors().size() > 0) {
            ValidationMessage vm = (ValidationMessage)vr.getValidationErrors().get(0);
            nexusErrorResponse = this.getNexusErrorResponse(vm.getKey(), vm.getShortMessage());
        } else {
            nexusErrorResponse = this.getNexusErrorResponse("*", e.getMessage());
        }
        throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)nexusErrorResponse);
    }

    protected void handleConfigurationException(ConfigurationException e) throws PlexusResourceException {
        ErrorResponse nexusErrorResponse;
        this.getLogger().debug("Configuration error!", (Throwable)e);
        if (InvalidConfigurationException.class.isAssignableFrom(((Object)((Object)e)).getClass())) {
            ValidationResponse vr = ((InvalidConfigurationException)e).getValidationResponse();
            if (vr != null && vr.getValidationErrors().size() > 0) {
                ValidationMessage vm = (ValidationMessage)vr.getValidationErrors().get(0);
                nexusErrorResponse = this.getNexusErrorResponse(vm.getKey(), vm.getShortMessage());
            } else {
                nexusErrorResponse = this.getNexusErrorResponse("*", e.getMessage());
            }
        } else {
            nexusErrorResponse = this.getNexusErrorResponse("*", e.getMessage());
        }
        throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)nexusErrorResponse);
    }

    protected Reference createRedirectBaseRef(Request request) {
        return this.createReference(this.getContextRoot(request), "service/local/artifact/maven/redirect").getTargetRef();
    }

    protected String getValidRemoteIPAddress(Request request) {
        return RemoteIPFinder.findIP(request);
    }

    protected String getActualPassword(String newPassword, String oldPassword) {
        if (PASSWORD_PLACE_HOLDER.equals(newPassword)) {
            return oldPassword;
        }
        return newPassword;
    }
}

