/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import java.io.IOException;
import javax.inject.Inject;
import org.restlet.data.Request;
import org.slf4j.Logger;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStore;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.router.RepositoryRouter;
import org.sonatype.nexus.proxy.router.RequestRoute;
import org.sonatype.nexus.rest.ArtifactViewProvider;
import org.sonatype.sisu.goodies.common.Loggers;

public abstract class AbstractArtifactViewProvider
implements ArtifactViewProvider {
    private final Logger logger = Loggers.getLogger(this.getClass());
    private RepositoryRouter repositoryRouter;

    @Inject
    public void setRepositoryRouter(RepositoryRouter repositoryRouter) {
        this.repositoryRouter = repositoryRouter;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object retrieveView(ResourceStore store, ResourceStoreRequest request, StorageItem item, Request req) throws IOException {
        RepositoryItemUid itemUid = null;
        if (item == null) {
            if (store instanceof RepositoryRouter) {
                RequestRoute route;
                RepositoryRouter repositoryRouter = (RepositoryRouter)store;
                try {
                    route = repositoryRouter.getRequestRouteForRequest(request);
                }
                catch (ItemNotFoundException e) {
                    return null;
                }
                Repository itemRepository = route.getTargetedRepository();
                itemUid = itemRepository.createUid(route.getRepositoryPath());
            } else {
                if (!(store instanceof Repository)) return null;
                itemUid = ((Repository)store).createUid(request.getRequestPath());
            }
        } else {
            itemUid = item.getRepositoryItemUid();
            if (item instanceof StorageLinkItem && this.dereferenceLinks()) {
                try {
                    item = this.repositoryRouter.dereferenceLink((StorageLinkItem)item, request.isRequestLocalOnly(), request.isRequestRemoteOnly());
                }
                catch (Exception e) {
                    this.getLogger().warn("Failed to dereference the storagelink " + item.getRepositoryItemUid(), (Throwable)e);
                }
            }
        }
        if (item != null || this.processNotFoundItems(itemUid.getRepository())) return this.retrieveView(request, itemUid, item, req);
        return null;
    }

    protected boolean dereferenceLinks() {
        return false;
    }

    protected boolean processNotFoundItems(Repository repo) {
        return !repo.getRepositoryKind().isFacetAvailable(HostedRepository.class);
    }

    protected abstract Object retrieveView(ResourceStoreRequest var1, RepositoryItemUid var2, StorageItem var3, Request var4) throws IOException;
}

