/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.ldap.realms.test.api;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.security.ldap.realms.api.AbstractLdapRealmPlexusResource;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserAndGroupConfigurationDTO;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserListResponse;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserResponseDTO;
import org.sonatype.nexus.security.ldap.realms.test.api.TestLdapManager;
import org.sonatype.nexus.security.ldap.realms.test.api.dto.LdapUserAndGroupConfigTestRequest;
import org.sonatype.nexus.security.ldap.realms.test.api.dto.LdapUserAndGroupConfigTestRequestDTO;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.ldap.dao.LdapAuthConfiguration;
import org.sonatype.security.ldap.dao.LdapConnectionTester;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.realms.LdapManager;
import org.sonatype.security.ldap.realms.persist.ConfigurationValidator;
import org.sonatype.security.ldap.realms.persist.LdapConfiguration;
import org.sonatype.security.ldap.realms.persist.UsersGroupAuthTestLdapConfiguration;
import org.sonatype.security.ldap.realms.persist.ValidationResponse;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;

@Path(value="/ldap/test_user_conf")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Singleton
@Named(value="LdapUserAndGroupConfigTestPlexusResource")
@Typed(value={PlexusResource.class})
public class LdapUserAndGroupConfigTestPlexusResource
extends AbstractLdapRealmPlexusResource {
    @Inject
    private LdapConnectionTester ldapConnectionTester;
    @Inject
    private ConfigurationValidator configurationValidator;
    @Inject
    @Named(value="UsersGroupAuthTestLdapConfiguration")
    private Provider<UsersGroupAuthTestLdapConfiguration> usersGroupAuthTestLdapConfigurationProvider;
    @Inject
    @Named(value="TestLdapManager")
    private Provider<TestLdapManager> testLdapManagerProvider;

    public LdapUserAndGroupConfigTestPlexusResource() {
        this.setModifiable(true);
        this.setReadable(false);
    }

    public Object getPayloadInstance() {
        return new LdapUserAndGroupConfigTestRequest();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:ldaptestuserconf]");
    }

    public String getResourceUri() {
        return "/ldap/test_user_conf";
    }

    @PUT
    @ResourceMethodSignature(input=LdapUserAndGroupConfigTestRequest.class, output=LdapUserListResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        LdapUserAndGroupConfigTestRequest configResponse = (LdapUserAndGroupConfigTestRequest)payload;
        LdapUserAndGroupConfigTestRequestDTO dto = configResponse.getData();
        ValidationResponse validationResponse = this.configurationValidator.validateConnectionInfo(null, this.getConnectionInfo(dto));
        this.handleValidationResponse(validationResponse);
        validationResponse = this.configurationValidator.validateUserAndGroupAuthConfiguration(null, this.restToLdapModel(dto));
        this.handleValidationResponse(validationResponse);
        LdapUserListResponse result = new LdapUserListResponse();
        try {
            int limit = dto.getUserLimitCount() != 0 ? dto.getUserLimitCount() : 20;
            result.setLdapUserRoleMappings(this.getPopulatedDTOs(this.convertToAuthConfig(dto), this.getConnectionInfo(dto), limit));
        }
        catch (Exception e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "LDAP Realm is not configured correctly: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private CConnectionInfo getConnectionInfo(LdapUserAndGroupConfigTestRequestDTO dto) {
        CConnectionInfo connInfo = new CConnectionInfo();
        connInfo.setAuthScheme(dto.getAuthScheme());
        connInfo.setHost(dto.getHost());
        connInfo.setPort(dto.getPort());
        connInfo.setProtocol(dto.getProtocol());
        connInfo.setSearchBase(dto.getSearchBase());
        connInfo.setSystemUsername(dto.getSystemUsername());
        connInfo.setRealm(dto.getRealm());
        if ("--FAKE-PASSWORD--".equals(dto.getSystemPassword())) {
            if (this.getConfiguration().readConnectionInfo() != null) {
                connInfo.setSystemPassword(this.getConfiguration().readConnectionInfo().getSystemPassword());
            }
        } else {
            connInfo.setSystemPassword(dto.getSystemPassword());
        }
        return connInfo;
    }

    private LdapAuthConfiguration convertToAuthConfig(LdapUserAndGroupConfigurationDTO dto) {
        LdapAuthConfiguration authConfig = new LdapAuthConfiguration();
        authConfig.setGroupMemberFormat(dto.getGroupMemberFormat());
        authConfig.setGroupObjectClass(dto.getGroupObjectClass());
        authConfig.setGroupBaseDn(dto.getGroupBaseDn());
        authConfig.setGroupIdAttribute(dto.getGroupIdAttribute());
        authConfig.setGroupMemberAttribute(dto.getGroupMemberAttribute());
        authConfig.setUserObjectClass(dto.getUserObjectClass());
        authConfig.setUserBaseDn(dto.getUserBaseDn());
        authConfig.setUserIdAttribute(dto.getUserIdAttribute());
        authConfig.setPasswordAttribute(dto.getUserPasswordAttribute());
        authConfig.setUserRealNameAttribute(dto.getUserRealNameAttribute());
        authConfig.setEmailAddressAttribute(dto.getEmailAddressAttribute());
        authConfig.setLdapGroupsAsRoles(dto.isLdapGroupsAsRoles());
        authConfig.setUserSubtree(dto.isUserSubtree());
        authConfig.setGroupSubtree(dto.isGroupSubtree());
        authConfig.setUserMemberOfAttribute(dto.getUserMemberOfAttribute());
        authConfig.setLdapFilter(dto.getLdapFilter());
        return authConfig;
    }

    protected LdapManager getLdapManager(LdapAuthConfiguration ldapAuthConfiguration, CConnectionInfo connectionInfo) throws ResourceException {
        UsersGroupAuthTestLdapConfiguration ldapConfiguration = (UsersGroupAuthTestLdapConfiguration)this.usersGroupAuthTestLdapConfigurationProvider.get();
        ldapConfiguration.setLdapAuthConfiguration(ldapAuthConfiguration);
        ldapConfiguration.setConnectionInfo(connectionInfo);
        TestLdapManager ldapManager = (TestLdapManager)((Object)this.testLdapManagerProvider.get());
        ldapManager.setLdapConfiguration((LdapConfiguration)ldapConfiguration);
        return ldapManager;
    }

    private List<LdapUserResponseDTO> getPopulatedDTOs(LdapAuthConfiguration ldapAuthConfiguration, CConnectionInfo cConnectionInfo, int limit) throws LdapDAOException, MalformedURLException, NamingException {
        ArrayList<LdapUserResponseDTO> result = new ArrayList<LdapUserResponseDTO>();
        SortedSet sUsers = this.ldapConnectionTester.testUserAndGroupMapping((LdapContextFactory)this.buildDefaultLdapContextFactory(cConnectionInfo), ldapAuthConfiguration, limit);
        for (LdapUser ldapUser : sUsers) {
            result.add(this.getPopulatedUser(ldapUser));
        }
        return result;
    }

    private LdapUserResponseDTO getPopulatedUser(LdapUser ldapUser) {
        LdapUserResponseDTO dto = new LdapUserResponseDTO();
        dto.setUserId(ldapUser.getUsername());
        dto.setEmail(ldapUser.getEmail());
        dto.setName(ldapUser.getRealName());
        for (String role : ldapUser.getMembership()) {
            dto.addRole(role);
        }
        return dto;
    }
}

