/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.ldap.realms.test.api;

import java.net.MalformedURLException;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.security.ldap.realms.api.AbstractLdapRealmPlexusResource;
import org.sonatype.nexus.security.ldap.realms.test.api.dto.LdapAuthenticationTestRequest;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.ldap.dao.LdapConnectionTester;
import org.sonatype.security.ldap.realms.DefaultLdapContextFactory;
import org.sonatype.security.ldap.realms.persist.ConfigurationValidator;
import org.sonatype.security.ldap.realms.persist.ValidationResponse;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;

@Path(value="/ldap/test_auth")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Singleton
@Named(value="LdapTestAuthenticationPlexusResource")
@Typed(value={PlexusResource.class})
public class LdapTestAuthenticationPlexusResource
extends AbstractLdapRealmPlexusResource {
    @Inject
    private LdapConnectionTester ldapConnectionTester;
    @Inject
    private ConfigurationValidator configurationValidator;

    public LdapTestAuthenticationPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new LdapAuthenticationTestRequest();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:ldaptestauth]");
    }

    public String getResourceUri() {
        return "/ldap/test_auth";
    }

    @PUT
    @ResourceMethodSignature(input=LdapAuthenticationTestRequest.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        LdapAuthenticationTestRequest authRequest = (LdapAuthenticationTestRequest)payload;
        CConnectionInfo connectionInfo = this.restToLdapModel(authRequest.getData());
        ValidationResponse validationResponse = this.configurationValidator.validateConnectionInfo(null, connectionInfo);
        this.handleValidationResponse(validationResponse);
        try {
            DefaultLdapContextFactory ldapContextFactory = this.buildDefaultLdapContextFactory(connectionInfo);
            this.ldapConnectionTester.testConnection((LdapContextFactory)ldapContextFactory);
        }
        catch (MalformedURLException e) {
            this.getLogger().warn("Validation of URL was successful, but failed after validation.", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().debug("Failed to connect to Ldap Server.", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Failed to connect to Ldap Server: " + e.getMessage(), (Throwable)e);
        }
        response.setStatus(Status.SUCCESS_NO_CONTENT);
        return null;
    }
}

