/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.ldap.realms.api;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.sonatype.nexus.rest.model.AliasingListConverter;
import org.sonatype.nexus.rest.model.HtmlUnescapeStringConverter;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapConnectionInfoDTO;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapConnectionInfoResponse;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserAndGroupConfigurationDTO;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserAndGroupConfigurationResponse;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserListResponse;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserResponseDTO;
import org.sonatype.nexus.security.ldap.realms.test.api.dto.LdapAuthenticationTestRequest;
import org.sonatype.nexus.security.ldap.realms.test.api.dto.LdapUserAndGroupConfigTestRequest;
import org.sonatype.nexus.security.ldap.realms.test.api.dto.LdapUserAndGroupConfigTestRequestDTO;

public class LdapXStreamConfigurator {
    public static XStream configureXStream(XStream xstream) {
        xstream.processAnnotations(LdapConnectionInfoResponse.class);
        xstream.processAnnotations(LdapUserAndGroupConfigurationResponse.class);
        xstream.processAnnotations(LdapUserListResponse.class);
        xstream.processAnnotations(LdapAuthenticationTestRequest.class);
        xstream.processAnnotations(LdapUserAndGroupConfigTestRequest.class);
        HtmlUnescapeStringConverter converter = new HtmlUnescapeStringConverter(true);
        xstream.registerLocalConverter(LdapConnectionInfoDTO.class, "systemUsername", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapConnectionInfoDTO.class, "systemPassword", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapConnectionInfoDTO.class, "searchBase", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserAndGroupConfigurationDTO.class, "groupBaseDn", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserAndGroupConfigurationDTO.class, "userBaseDn", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserAndGroupConfigurationDTO.class, "groupMemberFormat", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserAndGroupConfigurationDTO.class, "ldapFilter", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserAndGroupConfigTestRequestDTO.class, "systemUsername", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserAndGroupConfigTestRequestDTO.class, "systemPassword", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserAndGroupConfigTestRequestDTO.class, "searchBase", (SingleValueConverter)converter);
        xstream.registerLocalConverter(LdapUserListResponse.class, "data", (Converter)new AliasingListConverter(LdapUserResponseDTO.class, "user"));
        return xstream;
    }
}

