/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.ldap.realms.api;

import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.security.ldap.realms.api.AbstractLdapRealmPlexusResource;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapUserAndGroupConfigurationResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.ldap.realms.persist.InvalidConfigurationException;
import org.sonatype.security.ldap.realms.persist.model.CUserAndGroupAuthConfiguration;

@Path(value="/ldap/user_group_conf")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Singleton
@Named(value="LdapUserAndGroupsConfigurationPlexusResource")
@Typed(value={PlexusResource.class})
public class LdapUserAndGroupsConfigurationPlexusResource
extends AbstractLdapRealmPlexusResource {
    public LdapUserAndGroupsConfigurationPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new LdapUserAndGroupConfigurationResponse();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:ldapusergroupconf]");
    }

    public String getResourceUri() {
        return "/ldap/user_group_conf";
    }

    @GET
    @ResourceMethodSignature(output=LdapUserAndGroupConfigurationResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        CUserAndGroupAuthConfiguration userGroupConf = this.getConfiguration().readUserAndGroupConfiguration();
        LdapUserAndGroupConfigurationResponse result = new LdapUserAndGroupConfigurationResponse();
        if (userGroupConf != null) {
            result.setData(this.ldapToRestModel(userGroupConf));
        }
        return result;
    }

    @PUT
    @ResourceMethodSignature(input=LdapUserAndGroupConfigurationResponse.class, output=LdapUserAndGroupConfigurationResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        LdapUserAndGroupConfigurationResponse confResponse = (LdapUserAndGroupConfigurationResponse)payload;
        if (confResponse.getData() == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "LDAP Connection Info was missing from Request.");
        }
        CUserAndGroupAuthConfiguration userGroupConf = this.restToLdapModel(confResponse.getData());
        try {
            this.getConfiguration().updateUserAndGroupConfiguration(userGroupConf);
            this.getConfiguration().save();
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            this.handleConfigurationException(e);
        }
        return this.get(context, request, response, null);
    }
}

