/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.ldap.realms.api;

import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.security.ldap.realms.api.AbstractLdapRealmPlexusResource;
import org.sonatype.nexus.security.ldap.realms.api.dto.LdapConnectionInfoResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.security.ldap.realms.persist.InvalidConfigurationException;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;

@Path(value="/ldap/conn_info")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Singleton
@Named(value="LdapConnectionInfoPlexusResource")
@Typed(value={PlexusResource.class})
public class LdapConnectionInfoPlexusResource
extends AbstractLdapRealmPlexusResource {
    public LdapConnectionInfoPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new LdapConnectionInfoResponse();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:ldapconninfo]");
    }

    public String getResourceUri() {
        return "/ldap/conn_info";
    }

    @GET
    @ResourceMethodSignature(output=LdapConnectionInfoResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        CConnectionInfo connInfo = this.getConfiguration().readConnectionInfo();
        LdapConnectionInfoResponse result = new LdapConnectionInfoResponse();
        result.setData(this.ldapToRestModel(connInfo));
        return result;
    }

    @PUT
    @ResourceMethodSignature(input=LdapConnectionInfoResponse.class, output=LdapConnectionInfoResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        LdapConnectionInfoResponse connResponse = (LdapConnectionInfoResponse)payload;
        if (connResponse.getData() == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "LDAP Connection Info was missing from Request.");
        }
        CConnectionInfo connInfo = this.restToLdapModel(connResponse.getData());
        try {
            this.getConfiguration().updateConnectionInfo(connInfo);
            this.getConfiguration().save();
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            this.handleConfigurationException(e);
        }
        return this.get(context, request, response, null);
    }
}

