/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.ldap.realms;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.security.authentication.AuthenticationException;
import org.sonatype.security.ldap.LdapAuthenticator;
import org.sonatype.security.ldap.dao.LdapAuthConfiguration;
import org.sonatype.security.ldap.dao.LdapDAOException;
import org.sonatype.security.ldap.dao.LdapGroupDAO;
import org.sonatype.security.ldap.dao.LdapUser;
import org.sonatype.security.ldap.dao.LdapUserDAO;
import org.sonatype.security.ldap.dao.NoLdapUserRolesFoundException;
import org.sonatype.security.ldap.dao.NoSuchLdapGroupException;
import org.sonatype.security.ldap.dao.NoSuchLdapUserException;
import org.sonatype.security.ldap.realms.DefaultLdapContextFactory;
import org.sonatype.security.ldap.realms.LdapManager;
import org.sonatype.security.ldap.realms.connector.DefaultLdapConnector;
import org.sonatype.security.ldap.realms.connector.LdapConnector;
import org.sonatype.security.ldap.realms.persist.LdapConfiguration;
import org.sonatype.security.ldap.realms.persist.model.CConnectionInfo;
import org.sonatype.security.ldap.realms.tools.LdapURL;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractLdapManager
extends ComponentSupport
implements LdapManager {
    private final LdapAuthenticator ldapAuthenticator;
    private final LdapUserDAO ldapUserManager;
    private final LdapGroupDAO ldapGroupManager;
    private final LdapConfiguration ldapConfiguration;
    private LdapConnector ldapConnector;

    public AbstractLdapManager(LdapAuthenticator ldapAuthenticator, LdapUserDAO ldapUserManager, LdapGroupDAO ldapGroupManager, LdapConfiguration ldapConfiguration) {
        this.ldapAuthenticator = (LdapAuthenticator)Preconditions.checkNotNull((Object)ldapAuthenticator);
        this.ldapUserManager = (LdapUserDAO)Preconditions.checkNotNull((Object)ldapUserManager);
        this.ldapGroupManager = (LdapGroupDAO)Preconditions.checkNotNull((Object)ldapGroupManager);
        this.ldapConfiguration = (LdapConfiguration)Preconditions.checkNotNull((Object)ldapConfiguration);
    }

    public SortedSet<String> getAllGroups() throws LdapDAOException {
        return this.getLdapConnector().getAllGroups();
    }

    public SortedSet<LdapUser> getAllUsers() throws LdapDAOException {
        return this.getLdapConnector().getAllUsers();
    }

    public String getGroupName(String groupId) throws LdapDAOException, NoSuchLdapGroupException {
        return this.getLdapConnector().getGroupName(groupId);
    }

    public LdapUser getUser(String username) throws NoSuchLdapUserException, LdapDAOException {
        return this.getLdapConnector().getUser(username);
    }

    public Set<String> getUserRoles(String userId) throws LdapDAOException, NoLdapUserRolesFoundException {
        return this.getLdapConnector().getUserRoles(userId);
    }

    public SortedSet<LdapUser> getUsers(int userCount) throws LdapDAOException {
        return this.getLdapConnector().getUsers(userCount);
    }

    public SortedSet<LdapUser> searchUsers(String username, Set<String> roleIds) throws LdapDAOException {
        return this.getLdapConnector().searchUsers(username, roleIds);
    }

    private LdapConnector getLdapConnector() throws LdapDAOException {
        if (this.ldapConnector == null) {
            this.ldapConnector = new DefaultLdapConnector("default", this.ldapUserManager, this.ldapGroupManager, this.getLdapContextFactory(), this.getLdapAuthConfiguration());
        }
        return this.ldapConnector;
    }

    protected void resetLdapConnector() {
        this.ldapConnector = null;
    }

    protected LdapConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    protected LdapAuthConfiguration getLdapAuthConfiguration() {
        return this.getLdapConfiguration().getLdapAuthConfiguration();
    }

    protected LdapContextFactory getLdapContextFactory() throws LdapDAOException {
        String url;
        DefaultLdapContextFactory defaultLdapContextFactory = new DefaultLdapContextFactory();
        if (this.getLdapConfiguration() == null || this.getLdapConfiguration().readConnectionInfo() == null) {
            throw new LdapDAOException("Ldap connection is not configured.");
        }
        CConnectionInfo connInfo = this.getLdapConfiguration().readConnectionInfo();
        try {
            url = new LdapURL(connInfo.getProtocol(), connInfo.getHost(), connInfo.getPort(), connInfo.getSearchBase()).toString();
        }
        catch (MalformedURLException e) {
            this.log.error("LDAP Configuration is Invalid.");
            throw new LdapDAOException("Invalid LDAP URL: " + e.getMessage());
        }
        defaultLdapContextFactory.setUsePooling(true);
        defaultLdapContextFactory.setUrl(url);
        defaultLdapContextFactory.setSystemUsername(connInfo.getSystemUsername());
        defaultLdapContextFactory.setSystemPassword(connInfo.getSystemPassword());
        defaultLdapContextFactory.setSearchBase(connInfo.getSearchBase());
        defaultLdapContextFactory.setAuthentication(connInfo.getAuthScheme());
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        if (connInfo.getRealm() != null) {
            connectionProperties.put("java.naming.security.sasl.realm", connInfo.getRealm());
        }
        defaultLdapContextFactory.setAdditionalEnvironment(connectionProperties);
        return defaultLdapContextFactory;
    }

    public LdapUser authenticateUser(String userId, String password) throws AuthenticationException {
        try {
            LdapUser ldapUser = this.getUser(userId);
            String authScheme = this.getLdapConfiguration().readConnectionInfo().getAuthScheme();
            if (StringUtils.isEmpty((String)this.getLdapConfiguration().readUserAndGroupConfiguration().getUserPasswordAttribute())) {
                this.ldapAuthenticator.authenticateUserWithBind(ldapUser, password, this.getLdapContextFactory(), authScheme);
            } else {
                this.ldapAuthenticator.authenticateUserWithPassword(ldapUser, password);
            }
            return ldapUser;
        }
        catch (Exception e) {
            this.log.debug("Failed to find user: {}", (Object)userId, (Object)e);
            throw new AuthenticationException("User: " + userId + " could not be authenticated.");
        }
    }
}

