/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ui.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.plugin.support.UrlWebResource;
import org.sonatype.nexus.plugins.ui.internal.BuildNumberService;
import org.sonatype.nexus.web.WebResource;
import org.sonatype.nexus.web.WebResourceBundle;

@Named
public class WebResourceBundleImpl
implements WebResourceBundle {
    private final BuildNumberService buildNumberService;

    @Inject
    public WebResourceBundleImpl(BuildNumberService buildNumberService) {
        this.buildNumberService = buildNumberService;
    }

    public List<WebResource> getResources() {
        String prefix = this.buildNumberService.getBuildNumber();
        ArrayList<WebResource> result = new ArrayList<WebResource>();
        result.add((WebResource)new UrlWebResource(this.getClass().getResource("/static/js/nexus-ui-extjs3-plugin-all.js"), "/js/" + prefix + "/sonatype-all.js", "text/javascript"));
        result.add((WebResource)new UrlWebResource(this.getClass().getResource("/static/js/nx-all.js"), "/js/" + prefix + "/nx-all.js", "text/javascript"));
        result.add((WebResource)new UrlWebResource(this.getClass().getResource("/static/js/sonatype-lib.js"), "/js/" + prefix + "/sonatype-lib.js", "text/javascript"));
        result.add((WebResource)new UrlWebResource(this.getClass().getResource("/static/css/nexus-ui-extjs3-plugin-all.css"), "/style/" + prefix + "/sonatype-all.css", "text/css"));
        result.add((WebResource)new UrlWebResource(this.getClass().getResource("/static/css/nexus-ui-extjs3-plugin-all.css"), "/style/sonatype-all.css", "text/css"));
        return result;
    }
}

