/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ui.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.plugins.ui.contribution.UiContributor;
import org.sonatype.nexus.plugins.ui.internal.BuildNumberService;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.nexus.web.DelegatingWebResource;
import org.sonatype.nexus.web.WebResource;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.template.TemplateEngine;

@Named
@Singleton
public class IndexWebResource
extends ComponentSupport
implements WebResource,
WebResource.Prepareable {
    private final Provider<HttpServletRequest> requestProvider;
    private final ApplicationStatusSource applicationStatusSource;
    private final TemplateEngine templateEngine;
    private final BuildNumberService buildNumberService;
    private final Set<UiContributor> uiContributors;

    @Inject
    public IndexWebResource(Provider<HttpServletRequest> requestProvider, ApplicationStatusSource applicationStatusSource, TemplateEngine templateEngine, BuildNumberService buildNumberService, Set<UiContributor> uiContributors) {
        this.requestProvider = (Provider)Preconditions.checkNotNull(requestProvider);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.templateEngine = (TemplateEngine)Preconditions.checkNotNull((Object)templateEngine);
        this.buildNumberService = (BuildNumberService)((Object)Preconditions.checkNotNull((Object)((Object)buildNumberService)));
        this.uiContributors = (Set)Preconditions.checkNotNull(uiContributors);
    }

    public String getPath() {
        return "/index.html";
    }

    @Nullable
    public String getContentType() {
        return "text/html";
    }

    public long getLastModified() {
        return System.currentTimeMillis();
    }

    public boolean isCacheable() {
        return false;
    }

    public long getSize() {
        throw new UnsupportedOperationException("Preparation required");
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Preparation required");
    }

    private byte[] renderTemplate(String templateName) throws IOException {
        SystemStatus systemStatus = this.applicationStatusSource.getSystemStatus();
        HashMap params = Maps.newHashMap();
        params.put("serviceBase", "service/local");
        params.put("contentBase", "content");
        params.put("nexusVersion", systemStatus.getVersion());
        params.put("nexusRoot", BaseUrlHolder.get());
        params.put("appName", systemStatus.getAppName());
        params.put("formattedAppName", systemStatus.getFormattedAppName());
        boolean debugMode = this.isDebugMode();
        params.put("debug", debugMode);
        ArrayList contributions = Lists.newArrayList();
        for (UiContributor contributor : this.uiContributors) {
            UiContributor.UiContribution contribution = contributor.contribute(debugMode);
            if (!contribution.isEnabled()) continue;
            contributions.add(contribution);
        }
        params.put("rJsContributions", contributions);
        params.put("buildQualifier", this.buildNumberService.getBuildNumber());
        URL template = ((Object)((Object)this)).getClass().getResource(templateName);
        Preconditions.checkState((template != null ? 1 : 0) != 0, (String)"Missing template: %s", (Object[])new Object[]{templateName});
        this.log.debug("Rendering template: {}", (Object)template);
        String content = this.templateEngine.render((Object)this, template, (Map)params);
        return content.getBytes();
    }

    private boolean isDebugMode() {
        String query = ((HttpServletRequest)this.requestProvider.get()).getQueryString();
        return query != null && query.contains("debug");
    }

    public WebResource prepare() throws IOException {
        return new DelegatingWebResource(this){
            private final byte[] content;
            {
                this.content = IndexWebResource.this.renderTemplate("index.vm");
            }

            public long getSize() {
                return this.content.length;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(this.content);
            }
        };
    }
}

