/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ui.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
class BuildNumberService
extends ComponentSupport {
    private static final String RESOURCE_NAME = "version.properties";
    private final String buildNumber = this.loadVersion();

    public BuildNumberService() {
        this.log.debug("Build number: {}", (Object)this.buildNumber);
    }

    private String loadVersion() {
        URL url = ((Object)((Object)this)).getClass().getResource(RESOURCE_NAME);
        if (url == null) {
            this.log.error("Missing resource: {}", (Object)RESOURCE_NAME);
            return "unknown-version";
        }
        Properties props = new Properties();
        try (InputStream input = url.openStream();){
            props.load(input);
            this.log.debug("Loaded properties: {}", (Object)props);
        }
        catch (Exception e) {
            this.log.warn("Could not determine build number", (Throwable)e);
        }
        return props.getProperty("version", "unknown-version");
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }
}

