/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ui.contribution;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.plugin.PluginIdentity;
import org.sonatype.nexus.plugins.ui.contribution.UiContributionBuilder;
import org.sonatype.nexus.plugins.ui.contribution.UiContributor;

public class UiContributorSupport
implements UiContributor {
    private final PluginIdentity owner;

    public UiContributorSupport(PluginIdentity owner) {
        this.owner = (PluginIdentity)Preconditions.checkNotNull((Object)owner);
    }

    @Override
    public UiContributor.UiContribution contribute(boolean debug) {
        UiContributionBuilder builder = new UiContributionBuilder(this.owner);
        if (debug) {
            String css = String.format("static/css/%s.css", this.owner.getCoordinates().getArtifactId());
            if (this.owner.getClass().getClassLoader().getResource(css) != null) {
                builder.withDependency("css!" + css + builder.getCacheBuster(css));
            }
        }
        this.customize(builder);
        return builder.build(debug);
    }

    protected void customize(UiContributionBuilder builder) {
    }
}

