/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ui.contribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonatype.nexus.plugin.PluginIdentity;
import org.sonatype.nexus.plugins.ui.contribution.AbstractUiContributionBuilder;
import org.sonatype.nexus.plugins.ui.contribution.UiContributor;
import org.sonatype.nexus.util.Condition;

public class UiContributionBuilder
extends AbstractUiContributionBuilder<UiContributor.UiContribution> {
    private String module;
    private List<String> dependencies = Lists.newLinkedList();
    private Condition condition = new Condition(){

        public boolean isSatisfied() {
            return true;
        }
    };

    public UiContributionBuilder(Object owner, String groupId, String artifactId) {
        super(owner, groupId, artifactId);
    }

    public UiContributionBuilder(PluginIdentity owner) {
        this(owner, owner.getCoordinates().getGroupId(), owner.getCoordinates().getArtifactId());
    }

    public UiContributionBuilder boot(String module) {
        this.module = module;
        return this;
    }

    public UiContributionBuilder withDependency(String dependency) {
        Preconditions.checkNotNull((Object)dependency);
        this.dependencies.add(dependency);
        return this;
    }

    public UiContributionBuilder withDefaultAggregateDependency() {
        String js = this.getDefaultPath("js", true);
        return this.withDependency(js);
    }

    private void maybeAddDefaultCssDependency() {
        String path = this.getDefaultPath("css", false);
        if (this.owner.getClass().getClassLoader().getResource(path) != null) {
            this.withDependency("css!" + path + this.getCacheBuster(path));
        }
    }

    public UiContributionBuilder withDefaultCssDependency() {
        this.maybeAddDefaultCssDependency();
        return this;
    }

    public UiContributionBuilder setDefaultModule() {
        return this.boot(this.artifactId + "-boot");
    }

    @Override
    public UiContributor.UiContribution build() {
        return this.build(false);
    }

    public UiContributor.UiContribution build(boolean debug) {
        if (this.module == null) {
            this.setDefaultModule();
        }
        if (this.dependencies.isEmpty()) {
            this.maybeAddDefaultCssDependency();
            if (!debug) {
                this.withDefaultAggregateDependency();
            }
        }
        return new UiContributor.UiContribution(this.module, this.dependencies, this.condition.isSatisfied());
    }

    public UiContributionBuilder withCondition(Condition condition) {
        this.condition = (Condition)Preconditions.checkNotNull((Object)condition);
        return this;
    }
}

