/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ui.contribution;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractUiContributionBuilder<T>
extends ComponentSupport {
    protected final Object owner;
    protected final String groupId;
    protected final String artifactId;
    protected String encoding = "UTF-8";

    public AbstractUiContributionBuilder(Object owner, String groupId, String artifactId) {
        this.owner = Preconditions.checkNotNull((Object)owner);
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId);
        this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId);
    }

    private String detectVersion() {
        Properties props = new Properties();
        String path = String.format("/META-INF/maven/%s/%s/pom.properties", this.groupId, this.artifactId);
        InputStream input = this.owner.getClass().getResourceAsStream(path);
        if (input == null) {
            this.log.warn("Unable to detect version; failed to load: {}", (Object)path);
            return null;
        }
        try {
            props.load(input);
        }
        catch (IOException e) {
            this.log.warn("Failed to load POM: {}", (Object)path, (Object)e);
            return null;
        }
        return props.getProperty("version");
    }

    private long getTimestamp(String path) {
        URL url;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((url = this.owner.getClass().getResource(path)) != null) {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                return new File(url.getFile()).lastModified();
            }
            String resolvedPath = url.toExternalForm();
            if (resolvedPath.toLowerCase().startsWith("jar:file:")) {
                resolvedPath = resolvedPath.substring("jar:file:".length());
                File file = new File(resolvedPath = resolvedPath.substring(0, resolvedPath.length() - path.length() - 1));
                if (file.exists()) {
                    return file.lastModified();
                }
            }
        }
        return System.currentTimeMillis();
    }

    public String getCacheBuster(String path) {
        String version = this.detectVersion();
        if (version == null) {
            return "";
        }
        if (version.endsWith("SNAPSHOT")) {
            return String.format("?v=%s&t=%s", version, this.getTimestamp(path));
        }
        return "?v=" + version;
    }

    public String getDefaultPath(String extension, boolean bust) {
        String path = String.format("static/%s/%s-all.%s", extension, this.artifactId, extension);
        if (bust) {
            return path + this.getCacheBuster(path);
        }
        return path;
    }

    public String getDefaultPath(String extension) {
        return this.getDefaultPath(extension, true);
    }

    public abstract T build();
}

