/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.sonatype.nexus.rest.model.RepositoryUrlResource;

@XStreamAlias(value="artifact-info-resource")
@XmlType(name="artifact-info-resource")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ArtifactInfoResource
implements Serializable {
    private boolean presentLocally = false;
    private String repositoryId;
    private String repositoryName;
    private String repositoryPath;
    private String mimeType;
    private String uploader;
    private long uploaded = 0L;
    private long lastChanged = 0L;
    private long size = 0L;
    private String sha1Hash;
    private String md5Hash;
    @XmlElementWrapper(name="data")
    @XmlElement(name="repositories")
    private List<RepositoryUrlResource> repositories;
    private boolean canDelete = false;

    public void addRepository(RepositoryUrlResource repositoryUrlResource) {
        this.getRepositories().add(repositoryUrlResource);
    }

    public long getLastChanged() {
        return this.lastChanged;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List<RepositoryUrlResource> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<RepositoryUrlResource>();
        }
        return this.repositories;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getSha1Hash() {
        return this.sha1Hash;
    }

    public long getSize() {
        return this.size;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public String getUploader() {
        return this.uploader;
    }

    public boolean isCanDelete() {
        return this.canDelete;
    }

    public boolean isPresentLocally() {
        return this.presentLocally;
    }

    public void removeRepository(RepositoryUrlResource repositoryUrlResource) {
        this.getRepositories().remove(repositoryUrlResource);
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public void setLastChanged(long lastChanged) {
        this.lastChanged = lastChanged;
    }

    public void setMd5Hash(String md5Hash) {
        this.md5Hash = md5Hash;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setPresentLocally(boolean presentLocally) {
        this.presentLocally = presentLocally;
    }

    public void setRepositories(List<RepositoryUrlResource> repositories) {
        this.repositories = repositories;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public void setSha1Hash(String sha1Hash) {
        this.sha1Hash = sha1Hash;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setUploaded(long uploaded) {
        this.uploaded = uploaded;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }
}

