/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plugins.model.v1_0_0.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.sonatype.plugins.model.v1_0_0.ClasspathDependency;
import org.sonatype.plugins.model.v1_0_0.PluginDependency;
import org.sonatype.plugins.model.v1_0_0.PluginLicense;
import org.sonatype.plugins.model.v1_0_0.PluginMetadata;

public class PluginModelXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, PluginMetadata pluginMetadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(pluginMetadata.getModelEncoding(), null);
        this.writePluginMetadata(pluginMetadata, "plugin", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, PluginMetadata pluginMetadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, pluginMetadata.getModelEncoding());
        serializer.startDocument(pluginMetadata.getModelEncoding(), null);
        this.writePluginMetadata(pluginMetadata, "plugin", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeClasspathDependency(ClasspathDependency classpathDependency, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (classpathDependency.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(classpathDependency.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (classpathDependency.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(classpathDependency.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (classpathDependency.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(classpathDependency.getVersion()).endTag(NAMESPACE, "version");
        }
        if (classpathDependency.getClassifier() != null) {
            serializer.startTag(NAMESPACE, "classifier").text(classpathDependency.getClassifier()).endTag(NAMESPACE, "classifier");
        }
        if (classpathDependency.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(classpathDependency.getType()).endTag(NAMESPACE, "type");
        }
        if (classpathDependency.isHasComponents()) {
            serializer.startTag(NAMESPACE, "hasComponents").text(String.valueOf(classpathDependency.isHasComponents())).endTag(NAMESPACE, "hasComponents");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginDependency(PluginDependency pluginDependency, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginDependency.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(pluginDependency.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (pluginDependency.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(pluginDependency.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (pluginDependency.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(pluginDependency.getVersion()).endTag(NAMESPACE, "version");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginLicense(PluginLicense pluginLicense, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginLicense.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(pluginLicense.getType()).endTag(NAMESPACE, "type");
        }
        if (pluginLicense.getUrl() != null) {
            serializer.startTag(NAMESPACE, "url").text(pluginLicense.getUrl()).endTag(NAMESPACE, "url");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginMetadata(PluginMetadata pluginMetadata, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginMetadata.getModelVersion() != null) {
            serializer.startTag(NAMESPACE, "modelVersion").text(pluginMetadata.getModelVersion()).endTag(NAMESPACE, "modelVersion");
        }
        if (pluginMetadata.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(pluginMetadata.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (pluginMetadata.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(pluginMetadata.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (pluginMetadata.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(pluginMetadata.getVersion()).endTag(NAMESPACE, "version");
        }
        if (pluginMetadata.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(pluginMetadata.getName()).endTag(NAMESPACE, "name");
        }
        if (pluginMetadata.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(pluginMetadata.getDescription()).endTag(NAMESPACE, "description");
        }
        if (pluginMetadata.getPluginSite() != null) {
            serializer.startTag(NAMESPACE, "pluginSite").text(pluginMetadata.getPluginSite()).endTag(NAMESPACE, "pluginSite");
        }
        if (pluginMetadata.getApplicationId() != null) {
            serializer.startTag(NAMESPACE, "applicationId").text(pluginMetadata.getApplicationId()).endTag(NAMESPACE, "applicationId");
        }
        if (pluginMetadata.getApplicationEdition() != null) {
            serializer.startTag(NAMESPACE, "applicationEdition").text(pluginMetadata.getApplicationEdition()).endTag(NAMESPACE, "applicationEdition");
        }
        if (pluginMetadata.getApplicationMinVersion() != null) {
            serializer.startTag(NAMESPACE, "applicationMinVersion").text(pluginMetadata.getApplicationMinVersion()).endTag(NAMESPACE, "applicationMinVersion");
        }
        if (pluginMetadata.getApplicationMaxVersion() != null) {
            serializer.startTag(NAMESPACE, "applicationMaxVersion").text(pluginMetadata.getApplicationMaxVersion()).endTag(NAMESPACE, "applicationMaxVersion");
        }
        if (pluginMetadata.getScmVersion() != null) {
            serializer.startTag(NAMESPACE, "scmVersion").text(pluginMetadata.getScmVersion()).endTag(NAMESPACE, "scmVersion");
        }
        if (pluginMetadata.getScmTimestamp() != null) {
            serializer.startTag(NAMESPACE, "scmTimestamp").text(pluginMetadata.getScmTimestamp()).endTag(NAMESPACE, "scmTimestamp");
        }
        if (pluginMetadata.getLicenses() != null && pluginMetadata.getLicenses().size() > 0) {
            serializer.startTag(NAMESPACE, "licenses");
            for (PluginLicense pluginLicense : pluginMetadata.getLicenses()) {
                this.writePluginLicense(pluginLicense, "license", serializer);
            }
            serializer.endTag(NAMESPACE, "licenses");
        }
        if (pluginMetadata.getClasspathDependencies() != null && pluginMetadata.getClasspathDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "classpathDependencies");
            for (ClasspathDependency classpathDependency : pluginMetadata.getClasspathDependencies()) {
                this.writeClasspathDependency(classpathDependency, "classpathDependency", serializer);
            }
            serializer.endTag(NAMESPACE, "classpathDependencies");
        }
        if (pluginMetadata.getPluginDependencies() != null && pluginMetadata.getPluginDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "pluginDependencies");
            for (PluginDependency pluginDependency : pluginMetadata.getPluginDependencies()) {
                this.writePluginDependency(pluginDependency, "pluginDependency", serializer);
            }
            serializer.endTag(NAMESPACE, "pluginDependencies");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

