/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.atlas.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.sonatype.nexus.atlas.SupportBundle;
import org.sonatype.nexus.atlas.SupportBundleCustomizer;
import org.sonatype.nexus.atlas.SupportZipGenerator;
import org.sonatype.nexus.atlas.internal.FlushableZipOutputStream;
import org.sonatype.nexus.atlas.internal.SupportZipGeneratorImpl;
import org.sonatype.nexus.wonderland.DownloadService;
import org.sonatype.sisu.goodies.common.ByteSize;
import org.sonatype.sisu.goodies.common.ComponentSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class SupportZipGeneratorImpl
extends ComponentSupport
implements SupportZipGenerator,
GroovyObject {
    private final List<SupportBundleCustomizer> bundleCustomizers;
    private final DownloadService downloadService;
    private final ByteSize maxFileSize;
    private final ByteSize maxZipFileSize;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    @Inject
    public SupportZipGeneratorImpl(DownloadService downloadService, List<SupportBundleCustomizer> list, @Named(value="${atlas.supportZipGenerator.maxFileSize:-30mb}") ByteSize byteSize, @Named(value="${atlas.supportZipGenerator.maxZipFileSize:-20mb}") ByteSize byteSize2) {
        void maxZipFileSize;
        void maxFileSize;
        void bundleCustomizers;
        void downloadService2;
        MetaClass metaClass;
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            void v0 = downloadService2;
            valueRecorder.record((Object)v0, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)v0)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert downloadService", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Object object = callSiteArray[0].callStatic(Preconditions.class, (Object)bundleCustomizers);
        this.bundleCustomizers = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        void var9_9 = downloadService2;
        this.downloadService = (DownloadService)ScriptBytecodeAdapter.castToType((Object)var9_9, DownloadService.class);
        void var10_10 = maxFileSize;
        this.maxFileSize = (ByteSize)ScriptBytecodeAdapter.castToType((Object)var10_10, ByteSize.class);
        callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"Maximum included file size: {}", (Object)maxFileSize);
        void var11_11 = maxZipFileSize;
        this.maxZipFileSize = (ByteSize)ScriptBytecodeAdapter.castToType((Object)var11_11, ByteSize.class);
        callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)"Maximum ZIP file size: {}", (Object)maxZipFileSize);
    }

    private Set<SupportBundle.ContentSource.Type> includedTypes(SupportZipGenerator.Request request) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        List types = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGetProperty((Object)request))) {
            callSiteArray[6].call((Object)types, callSiteArray[7].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGetProperty((Object)request))) {
            callSiteArray[9].call((Object)types, callSiteArray[10].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callGetProperty((Object)request))) {
            callSiteArray[12].call((Object)types, callSiteArray[13].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGetProperty((Object)request))) {
            callSiteArray[15].call((Object)types, callSiteArray[16].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGetProperty((Object)request))) {
            callSiteArray[18].call((Object)types, callSiteArray[19].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callGetProperty((Object)request))) {
            callSiteArray[21].call((Object)types, callSiteArray[22].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)types, Set.class);
    }

    private List<SupportBundle.ContentSource> filterSources(SupportZipGenerator.Request request, SupportBundle supportBundle) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference include = new Reference(callSiteArray[23].callCurrent((GroovyObject)this, (Object)request));
        Reference sources = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        callSiteArray[24].call(callSiteArray[25].callGetProperty((Object)supportBundle), (Object)new GeneratedClosure(this, this, include, sources){
            private /* synthetic */ Reference include;
            private /* synthetic */ Reference sources;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.include = reference2 = include;
                this.sources = reference = sources;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.include.get(), callSiteArray[1].callGetProperty(it)))) {
                    callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"Including content source: {}", it);
                    return callSiteArray[4].call(this.sources.get(), it);
                }
                return null;
            }

            public Object getInclude() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.include.get();
            }

            public Object getSources() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.sources.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterSources_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _filterSources_closure1.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "type";
                stringArray[2] = "debug";
                stringArray[3] = "log";
                stringArray[4] = "leftShift";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _filterSources_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_filterSources_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _filterSources_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return (List)ScriptBytecodeAdapter.castToType((Object)sources.get(), List.class);
    }

    @Override
    public SupportZipGenerator.Result generate(SupportZipGenerator.Request request) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SupportZipGenerator.Request request2 = request;
            valueRecorder.record((Object)request2, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)request2)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert request", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty((Object)this), (Object)"Generating support ZIP: {}", (Object)request);
        Reference bundle = new Reference(callSiteArray[28].callConstructor(SupportBundle.class));
        callSiteArray[29].call(this.bundleCustomizers, (Object)new GeneratedClosure(this, this, bundle){
            private /* synthetic */ Reference bundle;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.bundle = reference = bundle;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Customizing bundle with: {}", it);
                return callSiteArray[2].call(it, this.bundle.get());
            }

            public Object getBundle() {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                return this.bundle.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _generate_closure2.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "customize";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _generate_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].call(callSiteArray[31].callGetProperty(bundle.get()))))) {
            ScriptBytecodeAdapter.assertFailed((Object)"bundle.sources.isEmpty()", (Object)"At least one bundle source must be configured");
        }
        Object sources = callSiteArray[32].callCurrent((GroovyObject)this, (Object)request, bundle.get());
        if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call(sources)))) {
            ScriptBytecodeAdapter.assertFailed((Object)"sources.isEmpty()", (Object)"At least one content source must be configured");
        }
        callSiteArray[34].call(sources, (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Preparing bundle source: {}", it);
                return callSiteArray[2].call(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _generate_closure3.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "prepare";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _generate_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        SupportZipGenerator.Result result = (SupportZipGenerator.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callCurrent((GroovyObject)this, (Object)request, sources), SupportZipGenerator.Result.class);
        callSiteArray[36].call(sources, (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Cleaning bundle source: {}", it);
                Object object = callSiteArray[2].call(it);
                try {
                    return object;
                }
                catch (Exception e) {
                    Object object2 = callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)"Bundle source cleanup failed", (Object)e);
                    return object2;
                }
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _generate_closure4.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "cleanup";
                stringArray[3] = "warn";
                stringArray[4] = "log";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _generate_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        try {
            return result;
        }
        catch (Exception e) {
            SupportZipGenerator.Result result2 = (SupportZipGenerator.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].call(callSiteArray[38].callGroovyObjectGetProperty((Object)this), (Object)"Failed to create support ZIP", (Object)e), SupportZipGenerator.Result.class);
            callSiteArray[39].call(sources, (Object)new /* invalid duplicate definition of identical inner class */);
            try {
                return result2;
            }
            catch (Throwable throwable) {
                callSiteArray[41].call(sources, (Object)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private SupportZipGenerator.Result createZip(SupportZipGenerator.Request request, List<SupportBundle.ContentSource> sources) {
        void var2_2;
        Reference request2 = new Reference((Object)request);
        Reference sources2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference prefix = new Reference(callSiteArray[42].call((Object)this.downloadService, (Object)"support-"));
        Object file = callSiteArray[43].callGetProperty(callSiteArray[44].call(File.class, (Object)new GStringImpl(new Object[]{prefix.get()}, new String[]{"", "-"}), (Object)".zip"));
        callSiteArray[45].call(callSiteArray[46].callGroovyObjectGetProperty((Object)this), (Object)"Writing ZIP file: {}", file);
        Reference stream = new Reference(callSiteArray[47].callConstructor(CountingOutputStream.class, callSiteArray[48].call(file)));
        Reference totalUncompressed = new Reference((Object)((Long)ScriptBytecodeAdapter.castToType((Object)0, Long.class)));
        Reference zip = new Reference(callSiteArray[49].callConstructor(FlushableZipOutputStream.class, stream.get()));
        Object object = callSiteArray[50].callGetProperty(Deflater.class);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)zip.get(), (String)"level");
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)zip.get(), (String)"syncFlush");
        Reference percentCompressed = new Reference((Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(long compressed, long uncompressed) {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call((Object)100, callSiteArray[1].call(callSiteArray[2].call((Object)compressed, (Object)uncompressed), (Object)100)), Integer.TYPE));
                }
                return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].call((Object)100, callSiteArray[4].call(callSiteArray[5].call((Object)compressed, (Object)uncompressed), (Object)100)), Integer.TYPE));
            }

            public Object call(long compressed, long uncompressed) {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                return callSiteArray[6].callCurrent((GroovyObject)this, (Object)compressed, (Object)uncompressed);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _createZip_closure5.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "minus";
                stringArray[1] = "multiply";
                stringArray[2] = "div";
                stringArray[3] = "minus";
                stringArray[4] = "multiply";
                stringArray[5] = "div";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _createZip_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        Reference addEntry = new Reference((Object)new GeneratedClosure(this, this, zip, prefix){
            private /* synthetic */ Reference zip;
            private /* synthetic */ Reference prefix;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.zip = reference2 = zip;
                this.prefix = reference = prefix;
            }

            public Object doCall(String path) {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)path, (Object)"/"))) {
                    Object object = callSiteArray[1].call((Object)"/", (Object)path);
                    path = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
                }
                Object entry = callSiteArray[2].callConstructor(ZipEntry.class, callSiteArray[3].call(this.prefix.get(), (Object)path));
                callSiteArray[4].call(this.zip.get(), entry);
                return entry;
            }

            public Object call(String path) {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                return callSiteArray[5].callCurrent((GroovyObject)this, (Object)path);
            }

            public Object getZip() {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                return this.zip.get();
            }

            public Object getPrefix() {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                return this.prefix.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _createZip_closure6.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "plus";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "plus";
                stringArray[4] = "putNextEntry";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _createZip_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        Reference closeEntry = new Reference((Object)new GeneratedClosure(this, this, zip, totalUncompressed, percentCompressed){
            private /* synthetic */ Reference zip;
            private /* synthetic */ Reference totalUncompressed;
            private /* synthetic */ Reference percentCompressed;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.zip = reference3 = zip;
                this.totalUncompressed = reference2 = totalUncompressed;
                this.percentCompressed = reference = percentCompressed;
            }

            public Object doCall(ZipEntry entry) {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                callSiteArray[0].call(this.zip.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty((Object)entry))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Entry (in={} out={}) bytes, compressed: {}%", callSiteArray[6].callGetProperty((Object)entry), callSiteArray[7].callGetProperty((Object)entry), callSiteArray[8].call(this.percentCompressed.get(), callSiteArray[9].callGetProperty((Object)entry), callSiteArray[10].callGetProperty((Object)entry)));
                    }
                    Object object = callSiteArray[11].call(this.totalUncompressed.get(), callSiteArray[12].callGetProperty((Object)entry));
                    this.totalUncompressed.set((Object)((Long)ScriptBytecodeAdapter.castToType((Object)object, Long.class)));
                    return object;
                }
                return null;
            }

            public Object call(ZipEntry entry) {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return callSiteArray[13].callCurrent((GroovyObject)this, (Object)entry);
            }

            public Object getZip() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return this.zip.get();
            }

            public Long getTotalUncompressed() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.totalUncompressed.get(), Long.class);
            }

            public Object getPercentCompressed() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return this.percentCompressed.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _createZip_closure7.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "closeEntry";
                stringArray[1] = "size";
                stringArray[2] = "debugEnabled";
                stringArray[3] = "log";
                stringArray[4] = "debug";
                stringArray[5] = "log";
                stringArray[6] = "size";
                stringArray[7] = "compressedSize";
                stringArray[8] = "call";
                stringArray[9] = "compressedSize";
                stringArray[10] = "size";
                stringArray[11] = "plus";
                stringArray[12] = "size";
                stringArray[13] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _createZip_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        GeneratedClosure addDirectoryEntries = new GeneratedClosure(this, this, addEntry, sources2, closeEntry){
            private /* synthetic */ Reference addEntry;
            private /* synthetic */ Reference sources;
            private /* synthetic */ Reference closeEntry;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.addEntry = reference3 = addEntry;
                this.sources = reference2 = sources;
                this.closeEntry = reference = closeEntry;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                callSiteArray[0].call(this.addEntry.get(), (Object)"/");
                Reference dirs = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
                callSiteArray[1].call(this.sources.get(), (Object)new GeneratedClosure((Object)this, this.getThisObject(), dirs){
                    private /* synthetic */ Reference dirs;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _createZip_closure8_closure10.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.dirs = reference = dirs;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _createZip_closure8_closure10.$getCallSiteArray();
                        List path = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(it), (Object)"/"), List.class);
                        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[2].call((Object)path), (Object)1)) {
                                int l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[3].call((Object)path));
                                while (l > 1) {
                                    callSiteArray[4].call(this.dirs.get(), callSiteArray[5].call(callSiteArray[6].call((Object)path, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)ScriptBytecodeAdapter.unaryMinus((Object)l), (boolean)true)), (Object)"/"));
                                    int n = l;
                                    l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[7].call((Object)n));
                                }
                                return null;
                            }
                            return null;
                        }
                        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[8].call((Object)path), (Object)1)) {
                            int l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[9].call((Object)path));
                            while (l > 1) {
                                callSiteArray[10].call(this.dirs.get(), callSiteArray[11].call(callSiteArray[12].call((Object)path, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)ScriptBytecodeAdapter.unaryMinus((Object)l), (boolean)true)), (Object)"/"));
                                int n = l;
                                int cfr_ignored_0 = n - 1;
                            }
                            return null;
                        }
                        return null;
                    }

                    public Set getDirs() {
                        CallSite[] callSiteArray = _createZip_closure8_closure10.$getCallSiteArray();
                        return (Set)ScriptBytecodeAdapter.castToType((Object)this.dirs.get(), Set.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _createZip_closure8_closure10.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createZip_closure8_closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                        CallSite[] callSiteArray = _createZip_closure8_closure10.$getCallSiteArray();
                        $callSiteArray = null;
                    }

                    static {
                        _createZip_closure8_closure10.__$swapInit();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "split";
                        stringArray[1] = "path";
                        stringArray[2] = "size";
                        stringArray[3] = "size";
                        stringArray[4] = "leftShift";
                        stringArray[5] = "join";
                        stringArray[6] = "getAt";
                        stringArray[7] = "previous";
                        stringArray[8] = "size";
                        stringArray[9] = "size";
                        stringArray[10] = "leftShift";
                        stringArray[11] = "join";
                        stringArray[12] = "getAt";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[13];
                        _createZip_closure8_closure10.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_createZip_closure8_closure10.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _createZip_closure8_closure10.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
                return callSiteArray[2].call(callSiteArray[3].call((Object)((Set)dirs.get())), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.addEntry, this.closeEntry){
                    private /* synthetic */ Reference addEntry;
                    private /* synthetic */ Reference closeEntry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _createZip_closure8_closure11.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.addEntry = reference2 = addEntry;
                        this.closeEntry = reference = closeEntry;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _createZip_closure8_closure11.$getCallSiteArray();
                        callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)((Object)this)), (Object)"Adding directory entry: {}", it);
                        Object entry = callSiteArray[2].call(this.addEntry.get(), (Object)new GStringImpl(new Object[]{it}, new String[]{"", "/"}));
                        return callSiteArray[3].call(this.closeEntry.get(), entry);
                    }

                    public Object getAddEntry() {
                        CallSite[] callSiteArray = _createZip_closure8_closure11.$getCallSiteArray();
                        return this.addEntry.get();
                    }

                    public Object getCloseEntry() {
                        CallSite[] callSiteArray = _createZip_closure8_closure11.$getCallSiteArray();
                        return this.closeEntry.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _createZip_closure8_closure11.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createZip_closure8_closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                        CallSite[] callSiteArray = _createZip_closure8_closure11.$getCallSiteArray();
                        $callSiteArray = null;
                    }

                    static {
                        _createZip_closure8_closure11.__$swapInit();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "debug";
                        stringArray[1] = "log";
                        stringArray[2] = "call";
                        stringArray[3] = "call";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _createZip_closure8_closure11.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_createZip_closure8_closure11.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _createZip_closure8_closure11.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }

            public Object getAddEntry() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.addEntry.get();
            }

            public List getSources() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.sources.get(), List.class);
            }

            public Object getCloseEntry() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.closeEntry.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _createZip_closure8.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "call";
                stringArray[1] = "each";
                stringArray[2] = "each";
                stringArray[3] = "sort";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _createZip_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        Reference maxContentSize = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].call((Object)this.maxFileSize), Integer.class)));
        Reference chunkSize = new Reference((Object)0);
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[52].call((Object)4, (Object)1024);
            chunkSize.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)object2, Integer.class)));
        } else {
            int n = 4 * 1024;
            chunkSize.set((Object)n);
        }
        Reference maxZipSize = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call(callSiteArray[54].call((Object)this.maxZipFileSize), callSiteArray[55].call((Object)DefaultTypeTransformation.intUnbox((Object)chunkSize.get()), (Object)2)), Integer.class)));
        Reference TRUNCATED_TOKEN = new Reference((Object)"** TRUNCATED **");
        Reference truncated = new Reference((Object)false);
        try {
            callSiteArray[56].call((Object)addDirectoryEntries);
            callSiteArray[57].call(callSiteArray[58].call((Object)((List)sources2.get())), (Object)new GeneratedClosure(this, this, zip, request2, TRUNCATED_TOKEN, maxZipSize, addEntry, chunkSize, closeEntry, stream, maxContentSize, truncated){
                private /* synthetic */ Reference zip;
                private /* synthetic */ Reference request;
                private /* synthetic */ Reference TRUNCATED_TOKEN;
                private /* synthetic */ Reference maxZipSize;
                private /* synthetic */ Reference addEntry;
                private /* synthetic */ Reference chunkSize;
                private /* synthetic */ Reference closeEntry;
                private /* synthetic */ Reference stream;
                private /* synthetic */ Reference maxContentSize;
                private /* synthetic */ Reference truncated;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    Reference reference8;
                    Reference reference9;
                    Reference reference10;
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.zip = reference10 = zip;
                    this.request = reference9 = request;
                    this.TRUNCATED_TOKEN = reference8 = TRUNCATED_TOKEN;
                    this.maxZipSize = reference7 = maxZipSize;
                    this.addEntry = reference6 = addEntry;
                    this.chunkSize = reference5 = chunkSize;
                    this.closeEntry = reference4 = closeEntry;
                    this.stream = reference3 = stream;
                    this.maxContentSize = reference2 = maxContentSize;
                    this.truncated = reference = truncated;
                }

                public Object doCall(Object source) {
                    Reference source2 = new Reference(source);
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Adding content entry: {} {} bytes", source2.get(), callSiteArray[2].callGetProperty(source2.get()));
                    Object entry = callSiteArray[3].call(this.addEntry.get(), callSiteArray[4].callGetProperty(source2.get()));
                    callSiteArray[5].call(callSiteArray[6].callGetProperty(source2.get()), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.zip, this.request, this.TRUNCATED_TOKEN, this.maxZipSize, this.chunkSize, this.stream, this.maxContentSize, this.truncated, source2){
                        private /* synthetic */ Reference zip;
                        private /* synthetic */ Reference request;
                        private /* synthetic */ Reference TRUNCATED_TOKEN;
                        private /* synthetic */ Reference maxZipSize;
                        private /* synthetic */ Reference chunkSize;
                        private /* synthetic */ Reference stream;
                        private /* synthetic */ Reference maxContentSize;
                        private /* synthetic */ Reference truncated;
                        private /* synthetic */ Reference source;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            Reference reference5;
                            Reference reference6;
                            Reference reference7;
                            Reference reference8;
                            Reference reference9;
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.zip = reference9 = zip;
                            this.request = reference8 = request;
                            this.TRUNCATED_TOKEN = reference7 = TRUNCATED_TOKEN;
                            this.maxZipSize = reference6 = maxZipSize;
                            this.chunkSize = reference5 = chunkSize;
                            this.stream = reference4 = stream;
                            this.maxContentSize = reference3 = maxContentSize;
                            this.truncated = reference2 = truncated;
                            this.source = reference = source;
                        }

                        public Object doCall(InputStream input) {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(this.request.get())) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[1].callGetProperty(this.source.get()), (Object)this.maxContentSize.get())) {
                                    callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)((Object)this)), (Object)"Truncating source contents; exceeds maximum included file size: {}", callSiteArray[4].callGetProperty(this.source.get()));
                                    callSiteArray[5].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                    boolean bl = true;
                                    this.truncated.set((Object)bl);
                                    callSiteArray[6].call((Object)input, callSiteArray[7].call(callSiteArray[8].callGetProperty(this.source.get()), this.maxContentSize.get()));
                                }
                            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty(this.request.get())) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[10].callGetProperty(this.source.get()), (Object)this.maxContentSize.get())) {
                                callSiteArray[11].call(callSiteArray[12].callGroovyObjectGetProperty((Object)((Object)this)), (Object)"Truncating source contents; exceeds maximum included file size: {}", callSiteArray[13].callGetProperty(this.source.get()));
                                callSiteArray[14].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                boolean bl = true;
                                this.truncated.set((Object)bl);
                                callSiteArray[15].call((Object)input, callSiteArray[16].call(callSiteArray[17].callGetProperty(this.source.get()), this.maxContentSize.get()));
                            }
                            byte[] buff = new byte[DefaultTypeTransformation.intUnbox((Object)this.chunkSize.get())];
                            int len = 0;
                            while (true) {
                                Object object = callSiteArray[18].call((Object)input, (Object)buff);
                                len = DefaultTypeTransformation.intUnbox((Object)object);
                                if (!ScriptBytecodeAdapter.compareNotEqual((Object)object, (Object)-1)) break;
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].callGetProperty(this.request.get())) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[20].call(callSiteArray[21].callGetProperty(this.stream.get()), (Object)len), (Object)this.maxZipSize.get())) {
                                    callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty((Object)((Object)this)), (Object)"Truncating source contents; max ZIP size reached: {}", callSiteArray[24].callGetProperty(this.source.get()));
                                    callSiteArray[25].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                    boolean bl = true;
                                    this.truncated.set((Object)bl);
                                    break;
                                }
                                callSiteArray[26].call(this.zip.get(), (Object)buff, (Object)0, (Object)len);
                                callSiteArray[27].call(this.zip.get());
                            }
                            return null;
                        }

                        public Object call(InputStream input) {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return callSiteArray[28].callCurrent((GroovyObject)this, (Object)input);
                        }

                        public Object getZip() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return this.zip.get();
                        }

                        public SupportZipGenerator.Request getRequest() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return (SupportZipGenerator.Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), SupportZipGenerator.Request.class);
                        }

                        public String getTRUNCATED_TOKEN() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return (String)ScriptBytecodeAdapter.castToType((Object)this.TRUNCATED_TOKEN.get(), String.class);
                        }

                        public Integer getMaxZipSize() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxZipSize.get(), Integer.class);
                        }

                        public Integer getChunkSize() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return (Integer)ScriptBytecodeAdapter.castToType((Object)this.chunkSize.get(), Integer.class);
                        }

                        public Object getStream() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return this.stream.get();
                        }

                        public Integer getMaxContentSize() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxContentSize.get(), Integer.class);
                        }

                        public Boolean getTruncated() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.truncated.get(), Boolean.class);
                        }

                        public Object getSource() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            return this.source.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _createZip_closure9_closure12.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public static /* synthetic */ void __$swapInit() {
                            CallSite[] callSiteArray = _createZip_closure9_closure12.$getCallSiteArray();
                            $callSiteArray = null;
                        }

                        static {
                            _createZip_closure9_closure12.__$swapInit();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "limitFileSizes";
                            stringArray[1] = "size";
                            stringArray[2] = "warn";
                            stringArray[3] = "log";
                            stringArray[4] = "path";
                            stringArray[5] = "leftShift";
                            stringArray[6] = "skip";
                            stringArray[7] = "minus";
                            stringArray[8] = "size";
                            stringArray[9] = "limitFileSizes";
                            stringArray[10] = "size";
                            stringArray[11] = "warn";
                            stringArray[12] = "log";
                            stringArray[13] = "path";
                            stringArray[14] = "leftShift";
                            stringArray[15] = "skip";
                            stringArray[16] = "minus";
                            stringArray[17] = "size";
                            stringArray[18] = "read";
                            stringArray[19] = "limitZipSize";
                            stringArray[20] = "plus";
                            stringArray[21] = "count";
                            stringArray[22] = "warn";
                            stringArray[23] = "log";
                            stringArray[24] = "path";
                            stringArray[25] = "leftShift";
                            stringArray[26] = "write";
                            stringArray[27] = "flush";
                            stringArray[28] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[29];
                            _createZip_closure9_closure12.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_createZip_closure9_closure12.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _createZip_closure9_closure12.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    });
                    return callSiteArray[7].call(this.closeEntry.get(), entry);
                }

                public Object getZip() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.zip.get();
                }

                public SupportZipGenerator.Request getRequest() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (SupportZipGenerator.Request)ScriptBytecodeAdapter.castToType((Object)this.request.get(), SupportZipGenerator.Request.class);
                }

                public String getTRUNCATED_TOKEN() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (String)ScriptBytecodeAdapter.castToType((Object)this.TRUNCATED_TOKEN.get(), String.class);
                }

                public Integer getMaxZipSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxZipSize.get(), Integer.class);
                }

                public Object getAddEntry() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.addEntry.get();
                }

                public Integer getChunkSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.chunkSize.get(), Integer.class);
                }

                public Object getCloseEntry() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.closeEntry.get();
                }

                public Object getStream() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.stream.get();
                }

                public Integer getMaxContentSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxContentSize.get(), Integer.class);
                }

                public Boolean getTruncated() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.truncated.get(), Boolean.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createZip_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    $callSiteArray = null;
                }

                static {
                    _createZip_closure9.__$swapInit();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "debug";
                    stringArray[1] = "log";
                    stringArray[2] = "size";
                    stringArray[3] = "call";
                    stringArray[4] = "path";
                    stringArray[5] = "withStream";
                    stringArray[6] = "content";
                    stringArray[7] = "call";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _createZip_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_createZip_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createZip_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            if (DefaultTypeTransformation.booleanUnbox((Object)((Boolean)truncated.get()))) {
                callSiteArray[59].call(addEntry.get(), (Object)"truncated");
            }
        }
        catch (Throwable throwable) {
            callSiteArray[61].call(zip.get());
            throw throwable;
        }
        callSiteArray[60].call(zip.get());
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].callGetProperty(callSiteArray[63].callGroovyObjectGetProperty((Object)this)))) {
            callSiteArray[64].call(callSiteArray[65].callGroovyObjectGetProperty((Object)this), (Object)"ZIP file (in={} out={}) bytes, compressed: {}%", (Object)((Long)totalUncompressed.get()), callSiteArray[66].callGetProperty(stream.get()), callSiteArray[67].call(percentCompressed.get(), callSiteArray[68].callGetProperty(stream.get()), (Object)((Long)totalUncompressed.get())));
        }
        Object target = callSiteArray[69].call((Object)this.downloadService, file, (Object)new GStringImpl(new Object[]{prefix.get()}, new String[]{"", ".zip"}));
        callSiteArray[70].call(callSiteArray[71].callGroovyObjectGetProperty((Object)this), (Object)"Created support ZIP file: {}", target);
        return (SupportZipGenerator.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(SupportZipGenerator.Result.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"file", target, "truncated", (Boolean)truncated.get()})), SupportZipGenerator.Result.class);
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SupportZipGeneratorImpl.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, SupportZipGeneratorImpl.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField(SupportZipGeneratorImpl.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SupportZipGeneratorImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        SupportZipGeneratorImpl.__$swapInit();
    }

    public /* synthetic */ Set this$3$includedTypes(SupportZipGenerator.Request request) {
        return this.includedTypes(request);
    }

    public /* synthetic */ List this$3$filterSources(SupportZipGenerator.Request request, SupportBundle supportBundle) {
        return this.filterSources(request, supportBundle);
    }

    public /* synthetic */ SupportZipGenerator.Result this$3$createZip(SupportZipGenerator.Request request, List list) {
        return this.createZip(request, list);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ Logger super$2$createLogger() {
        return super.createLogger();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkNotNull";
        stringArray[1] = "info";
        stringArray[2] = "log";
        stringArray[3] = "info";
        stringArray[4] = "log";
        stringArray[5] = "systemInformation";
        stringArray[6] = "leftShift";
        stringArray[7] = "SYSINFO";
        stringArray[8] = "threadDump";
        stringArray[9] = "leftShift";
        stringArray[10] = "THREAD";
        stringArray[11] = "metrics";
        stringArray[12] = "leftShift";
        stringArray[13] = "METRICS";
        stringArray[14] = "configuration";
        stringArray[15] = "leftShift";
        stringArray[16] = "CONFIG";
        stringArray[17] = "security";
        stringArray[18] = "leftShift";
        stringArray[19] = "SECURITY";
        stringArray[20] = "log";
        stringArray[21] = "leftShift";
        stringArray[22] = "LOG";
        stringArray[23] = "includedTypes";
        stringArray[24] = "each";
        stringArray[25] = "sources";
        stringArray[26] = "info";
        stringArray[27] = "log";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "each";
        stringArray[30] = "isEmpty";
        stringArray[31] = "sources";
        stringArray[32] = "filterSources";
        stringArray[33] = "isEmpty";
        stringArray[34] = "each";
        stringArray[35] = "createZip";
        stringArray[36] = "each";
        stringArray[37] = "error";
        stringArray[38] = "log";
        stringArray[39] = "each";
        stringArray[40] = "each";
        stringArray[41] = "each";
        stringArray[42] = "uniqueName";
        stringArray[43] = "canonicalFile";
        stringArray[44] = "createTempFile";
        stringArray[45] = "debug";
        stringArray[46] = "log";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "newOutputStream";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "DEFAULT_COMPRESSION";
        stringArray[51] = "toBytes";
        stringArray[52] = "multiply";
        stringArray[53] = "minus";
        stringArray[54] = "toBytes";
        stringArray[55] = "multiply";
        stringArray[56] = "call";
        stringArray[57] = "each";
        stringArray[58] = "sort";
        stringArray[59] = "call";
        stringArray[60] = "close";
        stringArray[61] = "close";
        stringArray[62] = "debugEnabled";
        stringArray[63] = "log";
        stringArray[64] = "debug";
        stringArray[65] = "log";
        stringArray[66] = "count";
        stringArray[67] = "call";
        stringArray[68] = "count";
        stringArray[69] = "move";
        stringArray[70] = "info";
        stringArray[71] = "log";
        stringArray[72] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[73];
        SupportZipGeneratorImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SupportZipGeneratorImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SupportZipGeneratorImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

