/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.eventbus.internal.guava;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.sonatype.sisu.goodies.eventbus.internal.guava.EventBus;
import org.sonatype.sisu.goodies.eventbus.internal.guava.EventHandler;

@Beta
public class AsyncEventBus
extends EventBus {
    private final Executor executor;
    private final ConcurrentLinkedQueue<EventBus.EventWithHandler> eventsToDispatch = new ConcurrentLinkedQueue();

    public AsyncEventBus(String identifier, Executor executor) {
        super(identifier);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public AsyncEventBus(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    protected void enqueueEvent(Object event, EventHandler handler) {
        this.eventsToDispatch.offer(new EventBus.EventWithHandler(event, handler));
    }

    @Override
    protected void dispatchQueuedEvents() {
        EventBus.EventWithHandler eventWithHandler;
        while ((eventWithHandler = this.eventsToDispatch.poll()) != null) {
            this.dispatch(eventWithHandler.event, eventWithHandler.handler);
        }
    }

    @Override
    protected void dispatch(final Object event, final EventHandler handler) {
        Preconditions.checkNotNull((Object)event);
        Preconditions.checkNotNull((Object)handler);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncEventBus.super.dispatch(event, handler);
            }
        });
    }
}

