/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.eventbus.internal;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.goodies.eventbus.internal.DefaultGuavaEventBus;
import org.sonatype.sisu.goodies.eventbus.internal.guava.EventBus;
import org.sonatype.sisu.goodies.eventbus.internal.guava.EventHandler;

@Named(value="reentrant")
@Singleton
public class ReentrantGuavaEventBus
extends DefaultGuavaEventBus {
    private final ThreadLocal<List<EventBus.EventWithHandler>> eventsToDispatch = new ThreadLocal();

    @Override
    protected void enqueueEvent(Object event, EventHandler handler) {
        if (this.eventsToDispatch.get() == null) {
            this.eventsToDispatch.set(Lists.newArrayList());
        }
        this.eventsToDispatch.get().add(new EventBus.EventWithHandler(event, handler));
    }

    @Override
    protected void dispatchQueuedEvents() {
        List<EventBus.EventWithHandler> eventWithHandlers = this.eventsToDispatch.get();
        if (eventWithHandlers != null) {
            this.eventsToDispatch.remove();
            for (EventBus.EventWithHandler eventWithHandler : eventWithHandlers) {
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
            }
        }
    }

    @Override
    public String toString() {
        return "Reentrant Guava EventBus";
    }
}

