/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.eventbus.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class DefaultEventBus
implements EventBus {
    static final Logger LOG = LoggerFactory.getLogger(DefaultEventBus.class);
    private static final Marker REGISTRATION = MarkerFactory.getMarker((String)"registration");
    private static final Marker EVENTS = MarkerFactory.getMarker((String)"events");
    static final Marker DISPATCHING = MarkerFactory.getMarker((String)"dispatching");
    private final org.sonatype.sisu.goodies.eventbus.internal.guava.EventBus eventBus;

    @Inject
    public DefaultEventBus(@Named(value="${guava.eventBus:-reentrant}") org.sonatype.sisu.goodies.eventbus.internal.guava.EventBus eventBus) {
        this.eventBus = (org.sonatype.sisu.goodies.eventbus.internal.guava.EventBus)Preconditions.checkNotNull((Object)eventBus);
        LOG.info("Using {}", (Object)eventBus);
    }

    @Override
    public EventBus register(Object handler) {
        this.eventBus.register(handler);
        LOG.debug(REGISTRATION, "Registered handler '{}'", handler);
        return this;
    }

    @Override
    public EventBus unregister(Object handler) {
        this.eventBus.unregister(handler);
        LOG.debug(REGISTRATION, "Unregistered handler '{}'", handler);
        return this;
    }

    @Override
    public EventBus post(Object event) {
        LOG.debug("Event '{}' fired", event);
        this.eventBus.post(event);
        return this;
    }
}

