/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugin.support;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.sonatype.nexus.web.WebResource;

public class UrlWebResource
implements WebResource {
    private final URL url;
    private final String path;
    private final boolean cacheable;
    private final String contentType;
    private final long size;
    private final long lastModified;

    public UrlWebResource(URL url, String path, String contentType) {
        this(url, path, contentType, true);
    }

    public UrlWebResource(URL url, String path, String contentType, boolean cacheable) {
        this.url = (URL)Preconditions.checkNotNull((Object)url);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.cacheable = cacheable;
        try {
            URLConnection connection = this.url.openConnection();
            try (InputStream ignore = connection.getInputStream();){
                this.contentType = Strings.isNullOrEmpty((String)contentType) ? connection.getContentType() : contentType;
                long size = connection.getContentLengthLong();
                if (size == -1L) {
                    size = connection.getContentLength();
                }
                this.size = size;
                this.lastModified = connection.getLastModified();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Resource inaccessible: " + url, e);
        }
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        return this.url.getPath();
    }

    public long getSize() {
        return this.size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String toString() {
        return "UrlWebResource{url=" + this.url + ", path='" + this.path + '\'' + ", isCacheable=" + this.cacheable + ", contentType='" + this.contentType + '\'' + '}';
    }
}

