/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugin.support;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sonatype.nexus.web.WebResource;

public class FileWebResource
implements WebResource {
    private final String path;
    private final String contentType;
    private final File file;
    private final boolean cachable;

    public FileWebResource(File file, String path, String contentType, boolean cachable) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
        this.cachable = cachable;
    }

    public boolean isCacheable() {
        return this.cachable;
    }

    public String getPath() {
        return this.path;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.file.length();
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public String toString() {
        return "FileWebResource{path='" + this.path + '\'' + ", contentType='" + this.contentType + '\'' + ", file=" + this.file + ", cachable=" + this.cachable + '}';
    }
}

