/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugin.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.wire.ParameterKeys;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.sonatype.sisu.goodies.common.Properties2;
import org.sonatype.sisu.goodies.inject.ModuleSupport;

public class ConfigurationPropertiesModule
extends ModuleSupport {
    private static final String DOT_PROPERTIES = ".properties";
    private final String fileName;
    private final String prefix;

    public ConfigurationPropertiesModule(@NonNls String fileName, @Nullable @NonNls String prefix) {
        this.fileName = (String)Preconditions.checkNotNull((Object)fileName);
        this.prefix = prefix;
    }

    public ConfigurationPropertiesModule(@NonNls String id) {
        this(id + DOT_PROPERTIES, id + ".");
    }

    protected void configure() {
        CustomProperties properties = new CustomProperties();
        this.requestInjection(properties);
        this.bind(ParameterKeys.PROPERTIES).toInstance((Object)properties);
    }

    private class CustomProperties
    extends AbstractMap<String, String> {
        private Map<String, String> properties = Collections.emptyMap();

        private CustomProperties() {
        }

        @Inject
        public void loadProperties(@Named(value="${application-conf}") String configDir) {
            try {
                File file = new File(configDir, ConfigurationPropertiesModule.this.fileName).getCanonicalFile();
                if (file.exists()) {
                    ConfigurationPropertiesModule.this.log.info("Loading properties: {}", (Object)file);
                    Properties props = Properties2.load((File)file);
                    if (ConfigurationPropertiesModule.this.prefix == null) {
                        this.properties = Maps.fromProperties((Properties)props);
                    } else {
                        ConfigurationPropertiesModule.this.log.debug("Applying prefix to keys: {}", (Object)ConfigurationPropertiesModule.this.prefix);
                        HashMap tmp = Maps.newHashMapWithExpectedSize((int)props.size());
                        for (String key : props.stringPropertyNames()) {
                            if (key.startsWith(ConfigurationPropertiesModule.this.prefix)) {
                                ConfigurationPropertiesModule.this.log.warn("Not applying prefix to already prefixed key: {}", (Object)key);
                                tmp.put(key, props.getProperty(key));
                                continue;
                            }
                            tmp.put(String.format("%s%s", ConfigurationPropertiesModule.this.prefix, key), props.getProperty(key));
                        }
                        this.properties = tmp;
                    }
                    if (ConfigurationPropertiesModule.this.log.isDebugEnabled() && !this.properties.isEmpty()) {
                        ConfigurationPropertiesModule.this.log.debug("Properties:");
                        for (String key : Properties2.sortKeys(this.properties)) {
                            ConfigurationPropertiesModule.this.log.debug("  {}={}", (Object)key, (Object)this.properties.get(key));
                        }
                    }
                }
            }
            catch (Exception e) {
                ConfigurationPropertiesModule.this.log.warn("Failed to load properties", (Throwable)e);
            }
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.properties.entrySet();
        }
    }
}

