/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugin.support;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.sisu.space.ClassSpace;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.plugin.support.DocumentationBundle;
import org.sonatype.nexus.plugin.support.UrlWebResource;
import org.sonatype.nexus.web.WebResource;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Deprecated
public abstract class AbstractDocumentationResourceBundle
extends ComponentSupport
implements DocumentationBundle {
    private MimeSupport mimeSupport;
    private ClassSpace space;

    protected AbstractDocumentationResourceBundle() {
    }

    @VisibleForTesting
    protected AbstractDocumentationResourceBundle(MimeSupport mimeSupport, ClassSpace space) {
        this.mimeSupport = mimeSupport;
        this.space = space;
    }

    @Inject
    public void setMimeSupport(MimeSupport mimeSupport, ClassSpace space) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
        this.space = (ClassSpace)Preconditions.checkNotNull((Object)space);
    }

    public List<WebResource> getResources() {
        LinkedList<WebResource> resources = new LinkedList<WebResource>();
        if (this.space != null) {
            Enumeration e = this.space.findEntries("docs", "*", true);
            while (e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                String name = url.getPath();
                name = name.substring(1 + name.lastIndexOf("/docs/"), name.length());
                String path = "/" + this.getPluginId() + "/" + this.getPathPrefix() + "/" + name;
                resources.add(new UrlWebResource(url, path, this.mimeSupport.guessMimeTypeFromPath(name)));
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Discovered documentation for: {}", (Object)this.getPluginId());
            for (WebResource resource : resources) {
                this.log.trace("  {}", (Object)resource);
            }
        }
        return resources;
    }

    @Override
    public String getPathPrefix() {
        return "default";
    }

    @Override
    public abstract String getDescription();

    @Override
    public abstract String getPluginId();
}

