/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugin;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.inject.Inject;
import org.sonatype.plugin.metadata.GAVCoordinate;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.Properties2;

public class PluginIdentity
extends ComponentSupport {
    public static final String UNKNOWN = "unknown";
    private final GAVCoordinate coordinates;

    @Inject
    public PluginIdentity(String groupId, String artifactId) throws Exception {
        this.coordinates = this.loadCoordinates(groupId, artifactId);
    }

    protected GAVCoordinate loadCoordinates(String groupId, String artifactId) throws IOException {
        String path = String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
        URL url = ((Object)((Object)this)).getClass().getResource(path);
        if (url == null) {
            this.log.warn("Missing plugin project metadata: {}", (Object)path);
            return new GAVCoordinate(groupId, artifactId, UNKNOWN);
        }
        Properties props = Properties2.load((URL)url);
        GAVCoordinate gav = new GAVCoordinate(props.getProperty("groupId", UNKNOWN), props.getProperty("artifactId", UNKNOWN), props.getProperty("version", UNKNOWN));
        if (!groupId.equals(gav.getGroupId())) {
            this.log.warn("Plugin groupId mismatch; expected: {}, found: {}", (Object)groupId, (Object)gav.getGroupId());
        }
        if (!artifactId.equals(gav.getArtifactId())) {
            this.log.warn("Plugin artifactId mismatch; expected: {}, found: {}", (Object)artifactId, (Object)gav.getArtifactId());
        }
        return gav;
    }

    public GAVCoordinate getCoordinates() {
        return this.coordinates;
    }

    public String getId() {
        return this.getCoordinates().getArtifactId();
    }

    public String getVersion() {
        return this.getCoordinates().getVersion();
    }
}

