/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.i18n;

import com.google.common.base.Preconditions;
import org.sonatype.sisu.goodies.i18n.MessageSource;

public class PrefixingMessageSource
implements MessageSource {
    private final MessageSource messages;
    private final String prefix;

    public PrefixingMessageSource(MessageSource messages, String prefix) {
        this.messages = (MessageSource)Preconditions.checkNotNull((Object)messages);
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix);
    }

    protected String createCode(String code) {
        Preconditions.checkNotNull((Object)code);
        return this.prefix + code;
    }

    @Override
    public String getMessage(String code) {
        return this.messages.getMessage(this.createCode(code));
    }

    @Override
    public String getMessage(String code, String defaultValue) {
        return this.messages.getMessage(this.createCode(code), defaultValue);
    }

    @Override
    public String format(String code, Object ... args) {
        return this.messages.format(this.createCode(code), args);
    }
}

