/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.client.internal;

import com.google.common.base.Preconditions;
import com.sonatype.analytics.client.AnalyticsClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import java.io.File;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.sisu.siesta.client.ClientBuilder;

public class AnalyticsClientImpl
implements AnalyticsClient {
    static final Logger log = LoggerFactory.getLogger(AnalyticsClientImpl.class);
    private final SubmitService submitService;

    public AnalyticsClientImpl(String url, Client client) {
        Preconditions.checkNotNull((Object)url, (Object)"Analytics service URL cannot be null");
        Preconditions.checkNotNull((Object)client, (Object)"Jersey Client cannot be null");
        if (log.isDebugEnabled()) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        this.submitService = (SubmitService)ClientBuilder.using((Client)client).toAccess(url).build(SubmitService.class);
    }

    @Override
    public void upload(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"File to be uploaded cannot be null");
        this.submitService.upload(new FormDataMultiPart().bodyPart((BodyPart)new FileDataBodyPart("file", file)));
    }

    @Override
    public void upload(InputStream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream of file to be uploaded cannot be null");
        this.submitService.upload(new FormDataMultiPart().bodyPart((BodyPart)new StreamDataBodyPart("file", stream)));
    }

    @Path(value="/submit")
    private static interface SubmitService {
        @POST
        @Consumes(value={"*/*"})
        @Produces(value={"multipart/form-data; boundary=-"})
        public void upload(MultiPart var1);
    }
}

