/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.sequence;

import com.google.common.base.Preconditions;
import io.kazuki.v0.internal.helper.JDBIHelper;
import io.kazuki.v0.store.KazukiException;
import io.kazuki.v0.store.sequence.SequenceServiceConfiguration;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;

public class SequenceHelper {
    private final boolean strictTypeCreation;
    private final String dbPrefix;
    private final String sequenceTableName;
    private final String keyTypesTableName;

    @Inject
    public SequenceHelper(SequenceServiceConfiguration sequenceServiceConfiguration) {
        this(sequenceServiceConfiguration.getDbPrefix(), sequenceServiceConfiguration.getGroupName(), sequenceServiceConfiguration.getStoreName(), sequenceServiceConfiguration.isStrictTypeCreation());
    }

    public SequenceHelper(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotNull((Object)string, (Object)"dbPrefix");
        Preconditions.checkNotNull((Object)string2, (Object)"groupName");
        Preconditions.checkNotNull((Object)string3, (Object)"storeName");
        this.dbPrefix = string;
        this.sequenceTableName = "_" + string2 + "_" + string3 + "__seq";
        this.keyTypesTableName = "_" + string2 + "_" + string3 + "__types";
        this.strictTypeCreation = bl;
    }

    public String getDbPrefix() {
        return this.dbPrefix;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public String getKeyTypesTableName() {
        return this.keyTypesTableName;
    }

    public Integer validateType(Handle handle, Map<String, Integer> map, Map<Integer, String> map2, String string, boolean bl) throws KazukiException {
        bl |= !this.strictTypeCreation;
        if (string == null || string.length() == 0 || string.indexOf(":") != -1 || string.length() > 72) {
            throw new IllegalArgumentException("Invalid entity 'type'");
        }
        if (map.containsKey(string)) {
            Integer n = map.get(string);
            return n;
        }
        Query<Map<String, Object>> query = JDBIHelper.getBoundQuery(handle, this.dbPrefix, "key_types_table_name", this.keyTypesTableName, "seq_types_get_id");
        query.bind("type_name", string);
        List list = query.list();
        Integer n = null;
        if (list == null || list.isEmpty()) {
            if (!bl) {
                return null;
            }
            n = this.getNextId(handle, 0, 1L).intValue();
            Update update = JDBIHelper.getBoundStatement(handle, this.dbPrefix, "sequence_table_name", this.sequenceTableName, "seq_seq_insert");
            update.bind("key_type", n);
            update.bind("next_id", 0L);
            update.execute();
            Update update2 = JDBIHelper.getBoundStatement(handle, this.dbPrefix, "key_types_table_name", this.keyTypesTableName, "seq_types_create");
            update2.bind("key_type", n);
            update2.bind("type_name", string);
            update2.execute();
        } else {
            n = ((Number)((Map)list.iterator().next()).get("_key_type")).intValue();
        }
        map.put(string, n);
        map2.put(n, string);
        return n;
    }

    public synchronized Long getNextId(Handle handle, Integer n, Long l) {
        Query<Map<String, Object>> query = JDBIHelper.getBoundQuery(handle, this.dbPrefix, "sequence_table_name", this.sequenceTableName, "seq_seq_next");
        query.bind("key_type", n);
        Long l2 = ((Number)((Map)query.first()).get("_next_id")).longValue();
        Update update = JDBIHelper.getBoundStatement(handle, this.dbPrefix, "sequence_table_name", this.sequenceTableName, "seq_seq_inc");
        update.bind("key_type", n);
        update.bind("increment", l);
        update.execute();
        return l2;
    }

    public synchronized void setNextId(Handle handle, Integer n, Long l) {
        Update update = JDBIHelper.getBoundStatement(handle, this.dbPrefix, "sequence_table_name", this.sequenceTableName, "seq_seq_set");
        update.bind("key_type", n);
        update.bind("next_id", l);
        update.execute();
    }

    public String getTypeName(Handle handle, Map<Integer, String> map, Integer n) throws KazukiException {
        if (n == null || n < 0) {
            throw new IllegalArgumentException("Invalid entity 'type'");
        }
        if (map.containsKey(n)) {
            return map.get(n);
        }
        Query<Map<String, Object>> query = JDBIHelper.getBoundQuery(handle, this.dbPrefix, "key_types_table_name", this.keyTypesTableName, "seq_types_get_name");
        query.bind("key_type", n);
        List list = query.list();
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid entity 'type'");
        }
        String string = (String)((Map)list.iterator().next()).get("_type_name");
        map.put(n, string);
        return string;
    }
}

