/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.sequence;

import io.kazuki.v0.internal.helper.KeyObfuscator;
import io.kazuki.v0.store.Key;

public class KeyImpl
implements Key {
    private final String internalIdentifier;
    private volatile String encryptedIdentifier;
    private volatile String encryptedId;
    private final String type;
    private final Long internalId;

    protected KeyImpl(String string, Long l) {
        this.internalIdentifier = string + ":" + Long.toString(l);
        this.type = string;
        this.internalId = l;
    }

    public static KeyImpl createInternal(String string, Long l) {
        return new KeyImpl(string, l);
    }

    public static Key valueOf(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        if (string.startsWith("@")) {
            return KeyObfuscator.decrypt(string);
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid key");
        }
        Long l = Long.parseLong(stringArray[1]);
        return new KeyImpl(stringArray[0], l);
    }

    @Override
    public String getTypePart() {
        return this.type;
    }

    @Override
    public String getIdPart() {
        this.computeEncryptedIds();
        return this.encryptedId;
    }

    @Override
    public String getIdentifier() {
        this.computeEncryptedIds();
        return this.encryptedIdentifier;
    }

    public boolean equals(Object object) {
        return object instanceof KeyImpl && this.internalIdentifier.equals(((KeyImpl)object).internalIdentifier);
    }

    public int hashCode() {
        return this.internalIdentifier.hashCode();
    }

    public String toString() {
        return this.getIdentifier();
    }

    public String getInternalIdentifier() {
        return this.internalIdentifier;
    }

    public Long getInternalId() {
        return this.internalId;
    }

    private void computeEncryptedIds() {
        if (this.encryptedIdentifier == null) {
            this.encryptedIdentifier = KeyObfuscator.encrypt(this.type, this.internalId);
            this.encryptedId = this.encryptedIdentifier.split(":")[1];
        }
    }
}

