/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.schema;

import com.google.common.base.Throwables;
import io.kazuki.v0.internal.helper.LogTranslation;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.internal.v2schema.SchemaValidator;
import io.kazuki.v0.internal.v2schema.types.TransformException;
import io.kazuki.v0.store.KazukiException;
import io.kazuki.v0.store.Key;
import io.kazuki.v0.store.keyvalue.KeyValueStore;
import io.kazuki.v0.store.schema.SchemaStore;
import io.kazuki.v0.store.schema.TypeValidation;
import io.kazuki.v0.store.sequence.KeyImpl;
import io.kazuki.v0.store.sequence.ResolvedKey;
import io.kazuki.v0.store.sequence.SequenceService;
import javax.inject.Inject;
import org.slf4j.Logger;

public class SchemaStoreImpl
implements SchemaStore {
    public static final String SCHEMA_PREFIX = "$schema";
    private final Logger log = LogTranslation.getLogger(this.getClass());
    private final SequenceService sequences;
    private KeyValueStore store;

    @Inject
    public SchemaStoreImpl(SequenceService sequenceService) {
        this.sequences = sequenceService;
    }

    @Inject
    public synchronized void setKeyValueStorage(KeyValueStore keyValueStore) {
        this.log.debug("Setting schema KeyValueStore for {}", (Object)this);
        this.store = keyValueStore;
    }

    @Override
    public synchronized Key createSchema(String string, Schema schema) throws KazukiException {
        if (this.store == null) {
            throw new IllegalStateException("schemaManager not initialized with KV store");
        }
        Integer n = this.getTypeIdPossiblyNull(string, true);
        if (n == null) {
            throw new KazukiException("unable to allocate new type id for Schema type: " + string);
        }
        KeyImpl keyImpl = KeyImpl.createInternal(SCHEMA_PREFIX, n.longValue());
        Schema schema2 = this.store.retrieve(keyImpl, Schema.class);
        if (schema2 != null) {
            return keyImpl;
        }
        try {
            SchemaValidator.validate(schema);
        }
        catch (TransformException transformException) {
            throw new KazukiException("invalid schema definition for type: " + string, transformException);
        }
        ResolvedKey resolvedKey = this.sequences.resolveKey(keyImpl);
        this.store.create(SCHEMA_PREFIX, Schema.class, schema, resolvedKey, TypeValidation.LAX);
        return keyImpl;
    }

    @Override
    public synchronized Schema retrieveSchema(String string) throws KazukiException {
        if (this.store == null) {
            throw new IllegalStateException("schemaManager not initialized with KV store");
        }
        Integer n = this.getTypeIdPossiblyNull(string, false);
        if (n == null || string.equals(SCHEMA_PREFIX)) {
            return null;
        }
        return this.store.retrieve(KeyImpl.createInternal(SCHEMA_PREFIX, n.longValue()), Schema.class);
    }

    @Override
    public synchronized boolean updateSchema(String string, Schema schema) throws KazukiException {
        if (this.store == null) {
            throw new IllegalStateException("schemaManager not initialized with KV store");
        }
        Integer n = this.getTypeIdPossiblyNull(string, false);
        if (n == null) {
            return false;
        }
        KeyImpl keyImpl = KeyImpl.createInternal(SCHEMA_PREFIX, n.longValue());
        Schema schema2 = this.store.retrieve(keyImpl, Schema.class);
        if (schema2 == null) {
            return false;
        }
        try {
            SchemaValidator.validate(schema);
            SchemaValidator.validateUpgrade(schema2, schema);
        }
        catch (TransformException transformException) {
            throw new KazukiException("invalid Schema update for type: " + string, transformException);
        }
        return this.store.update(keyImpl, Schema.class, schema);
    }

    @Override
    public synchronized boolean deleteSchema(String string) throws KazukiException {
        if (this.store == null) {
            throw new IllegalStateException("schemaManager not initialized with KV store");
        }
        Integer n = this.getTypeIdPossiblyNull(string, true);
        if (n == null) {
            return false;
        }
        KeyImpl keyImpl = KeyImpl.createInternal(SCHEMA_PREFIX, n.longValue());
        return this.store.deleteHard(keyImpl);
    }

    @Override
    public synchronized void clear() throws KazukiException {
        this.store.clear(SCHEMA_PREFIX);
    }

    private Integer getTypeIdPossiblyNull(String string, boolean bl) {
        try {
            return this.sequences.getTypeId(string, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }
}

