/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.lifecycle;

import io.kazuki.v0.internal.helper.LogTranslation;
import io.kazuki.v0.store.lifecycle.LifecycleAware;
import io.kazuki.v0.store.lifecycle.LifecycleEvent;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;

public class Lifecycle {
    private final Logger log = LogTranslation.getLogger(this.getClass());
    private static final EnumSet<LifecycleEvent> reverseOrder = EnumSet.of(LifecycleEvent.UNANNOUNCE, LifecycleEvent.STOP, LifecycleEvent.SHUTDOWN);
    private final ConcurrentLinkedDeque<LifecycleAware> listeners = new ConcurrentLinkedDeque();
    private final String name;

    public Lifecycle(String string) {
        this.name = string;
    }

    public void register(LifecycleAware lifecycleAware) {
        this.log.debug("Registering Lifecycle listener {}", (Object)lifecycleAware);
        this.listeners.add(lifecycleAware);
    }

    public void init() {
        this.fireEvent(LifecycleEvent.INIT);
    }

    public void start() {
        this.fireEvent(LifecycleEvent.START);
    }

    public void announce() {
        this.fireEvent(LifecycleEvent.ANNOUNCE);
    }

    public void unannounce() {
        this.fireEvent(LifecycleEvent.UNANNOUNCE);
    }

    public void shutdown() {
        this.fireEvent(LifecycleEvent.SHUTDOWN);
    }

    public void stop() {
        this.fireEvent(LifecycleEvent.STOP);
    }

    public String getName() {
        return this.name;
    }

    private void fireEvent(LifecycleEvent lifecycleEvent) {
        Iterator<LifecycleAware> iterator;
        this.log.debug("Firing lifecycle event {} to all listeners", (Object)lifecycleEvent.name());
        Iterator<LifecycleAware> iterator2 = iterator = reverseOrder.contains((Object)lifecycleEvent) ? this.listeners.descendingIterator() : this.listeners.iterator();
        while (iterator.hasNext()) {
            LifecycleAware lifecycleAware = iterator.next();
            this.log.trace("Firing lifecycle event {} to listener {}", (Object)lifecycleEvent.name(), (Object)lifecycleAware);
            lifecycleAware.eventFired(lifecycleEvent);
        }
        this.log.debug("Fired lifecycle event {}", (Object)lifecycleEvent.name());
    }
}

