/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.keyvalue;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.kazuki.v0.store.config.ConfigurationBuilder;

public class KeyValueStoreConfiguration {
    private final String dbType;
    private final String dbPrefix;
    private final String dataType;
    private final String groupName;
    private final String storeName;
    private final String partitionName;
    private final boolean strictTypeCreation;
    private final Long partitionSize;

    public KeyValueStoreConfiguration(@JsonProperty(value="dbType") String string, @JsonProperty(value="dataType") String string2, @JsonProperty(value="groupName") String string3, @JsonProperty(value="storeName") String string4, @JsonProperty(value="partitionName") String string5, @JsonProperty(value="partitionSize") Long l, @JsonProperty(value="strictTypeCreation") boolean bl) {
        Preconditions.checkNotNull((Object)string, (Object)"dbType");
        Preconditions.checkArgument((!string.contains("_") && !string.contains(":") ? 1 : 0) != 0, (Object)"invalid dbType");
        Preconditions.checkNotNull((Object)string3, (Object)"groupName");
        Preconditions.checkNotNull((Object)string4, (Object)"storeName");
        Preconditions.checkArgument((string5 != null || l != null ? 1 : 0) != 0, (Object)"partitionName or partitionSize must be set");
        Preconditions.checkArgument((l == null || l > 1L ? 1 : 0) != 0, (Object)"invalid partitionSize");
        this.dbType = string;
        this.dataType = string2;
        this.dbPrefix = string + ":" + string + "_";
        this.groupName = string3;
        this.storeName = string4;
        this.partitionName = string5 != null ? string5 : String.format("%016x", 0L);
        this.partitionSize = l;
        this.strictTypeCreation = bl;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDbPrefix() {
        return this.dbPrefix;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Long getPartitionSize() {
        return this.partitionSize;
    }

    public boolean isStrictTypeCreation() {
        return this.strictTypeCreation;
    }

    public static class Builder
    implements ConfigurationBuilder<KeyValueStoreConfiguration> {
        private String dbType;
        private String dataType;
        private String groupName;
        private String storeName;
        private String partitionName;
        private Long partitionSize;
        private boolean strictTypeCreation = true;

        public Builder withDbType(String string) {
            this.dbType = string;
            return this;
        }

        public Builder withDataType(String string) {
            this.dataType = string;
            return this;
        }

        public Builder withGroupName(String string) {
            this.groupName = string;
            return this;
        }

        public Builder withStoreName(String string) {
            this.storeName = string;
            return this;
        }

        public Builder withPartitionName(String string) {
            this.partitionName = string;
            return this;
        }

        public Builder withPartitionSize(Long l) {
            this.partitionSize = l;
            return this;
        }

        public Builder withStrictTypeCreation(boolean bl) {
            this.strictTypeCreation = bl;
            return this;
        }

        @Override
        public KeyValueStoreConfiguration build() {
            return new KeyValueStoreConfiguration(this.dbType, this.dataType, this.groupName, this.storeName, this.partitionName, this.partitionSize, this.strictTypeCreation);
        }
    }
}

