/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.jdbi;

import com.google.common.base.Throwables;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import io.kazuki.v0.internal.helper.MaskProxy;
import io.kazuki.v0.internal.helper.ResourceHelper;
import io.kazuki.v0.store.config.ConfigurationProvider;
import io.kazuki.v0.store.jdbi.JdbiDataSourceConfiguration;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.lifecycle.LifecycleRegistration;
import io.kazuki.v0.store.lifecycle.LifecycleSupportBase;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.jdbcx.JdbcDataSource;

public class H2DataSourceModule
extends PrivateModule {
    private final String name;
    private final String propertiesPath;
    private final String[] additionalNames;
    private final AtomicReference<JdbiDataSourceConfiguration> config;

    public H2DataSourceModule(String string, @Nullable String string2, String ... stringArray) {
        this.name = string;
        this.propertiesPath = string2;
        this.additionalNames = stringArray;
        this.config = new AtomicReference();
    }

    public H2DataSourceModule withConfiguration(JdbiDataSourceConfiguration jdbiDataSourceConfiguration) {
        this.config.set(jdbiDataSourceConfiguration);
        return this;
    }

    protected void configure() {
        JdbiDataSourceConfiguration jdbiDataSourceConfiguration = this.config.get();
        if (jdbiDataSourceConfiguration != null) {
            this.bind(JdbiDataSourceConfiguration.class).toInstance((Object)jdbiDataSourceConfiguration);
        } else if (this.propertiesPath != null) {
            this.bind(JdbiDataSourceConfiguration.class).toProvider(new ConfigurationProvider<JdbiDataSourceConfiguration>(this.name, JdbiDataSourceConfiguration.class, this.propertiesPath, true));
        } else {
            this.bind(JdbiDataSourceConfiguration.class).to(Key.get(JdbiDataSourceConfiguration.class, (Annotation)Names.named((String)this.name)));
        }
        this.bind(Lifecycle.class).to(Key.get(Lifecycle.class, (Annotation)Names.named((String)this.name)));
        this.bind(DataSource.class).annotatedWith((Annotation)Names.named((String)this.name)).toProvider(H2DataSourceProvider.class).in(Scopes.SINGLETON);
        this.expose(DataSource.class).annotatedWith((Annotation)Names.named((String)this.name));
        if (this.additionalNames != null) {
            for (String string : this.additionalNames) {
                this.bind(DataSource.class).annotatedWith((Annotation)Names.named((String)string)).to(Key.get(DataSource.class, (Annotation)Names.named((String)this.name)));
                this.expose(DataSource.class).annotatedWith((Annotation)Names.named((String)string));
            }
        }
    }

    private static class H2DataSourceProvider
    implements Provider<DataSource>,
    LifecycleRegistration {
        private final JdbiDataSourceConfiguration config;
        private final MaskProxy<DataSource, JdbcConnectionPool> instance;

        @Inject
        public H2DataSourceProvider(JdbiDataSourceConfiguration jdbiDataSourceConfiguration) {
            this.config = jdbiDataSourceConfiguration;
            this.instance = new MaskProxy<DataSource, Object>(DataSource.class, null);
        }

        @Override
        @Inject
        public void register(Lifecycle lifecycle) {
            lifecycle.register(new LifecycleSupportBase(){

                @Override
                public void init() {
                    H2DataSourceProvider.this.instance.getAndSet(H2DataSourceProvider.this.createDataSource());
                }

                @Override
                public void shutdown() {
                    JdbcConnectionPool jdbcConnectionPool = H2DataSourceProvider.this.instance.getAndSet(null);
                    try {
                        jdbcConnectionPool.dispose();
                    }
                    catch (Exception exception) {
                        throw Throwables.propagate((Throwable)exception);
                    }
                }
            });
        }

        public DataSource get() {
            return this.instance.asProxyInstance();
        }

        private JdbcConnectionPool createDataSource() {
            ResourceHelper.forName(this.config.getJdbcDriver(), this.getClass());
            JdbcDataSource jdbcDataSource = new JdbcDataSource();
            jdbcDataSource.setURL(this.config.getJdbcUrl());
            jdbcDataSource.setUser(this.config.getJdbcUser());
            jdbcDataSource.setPassword(this.config.getJdbcPassword());
            JdbcConnectionPool jdbcConnectionPool = JdbcConnectionPool.create((ConnectionPoolDataSource)jdbcDataSource);
            jdbcConnectionPool.setMaxConnections(this.config.getPoolMaxConnections());
            return jdbcConnectionPool;
        }
    }
}

