/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.easy;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.kazuki.v0.store.jdbi.H2DataSourceModule;
import io.kazuki.v0.store.jdbi.JdbiDataSourceConfiguration;
import io.kazuki.v0.store.journal.SimpleJournalStoreModule;
import io.kazuki.v0.store.keyvalue.KeyValueStoreConfiguration;
import io.kazuki.v0.store.sequence.H2SequenceServiceModule;
import io.kazuki.v0.store.sequence.SequenceServiceConfiguration;
import java.util.concurrent.atomic.AtomicReference;

public class EasyJournalStoreModule
extends AbstractModule {
    private final String name;
    private final String propertiesBase;
    private final AtomicReference<JdbiDataSourceConfiguration> jdbiConfig;
    private final AtomicReference<SequenceServiceConfiguration> sequenceConfig;
    private final AtomicReference<KeyValueStoreConfiguration> keyValueConfig;

    public EasyJournalStoreModule(String string, String string2) {
        this.name = string;
        this.propertiesBase = string2;
        this.jdbiConfig = new AtomicReference();
        this.sequenceConfig = new AtomicReference();
        this.keyValueConfig = new AtomicReference();
    }

    public EasyJournalStoreModule withJdbiConfig(JdbiDataSourceConfiguration jdbiDataSourceConfiguration) {
        this.jdbiConfig.set(jdbiDataSourceConfiguration);
        return this;
    }

    public EasyJournalStoreModule withSequenceConfig(SequenceServiceConfiguration sequenceServiceConfiguration) {
        this.sequenceConfig.set(sequenceServiceConfiguration);
        return this;
    }

    public EasyJournalStoreModule withKeyValueStoreConfig(KeyValueStoreConfiguration keyValueStoreConfiguration) {
        this.keyValueConfig.set(keyValueStoreConfiguration);
        return this;
    }

    protected void configure() {
        this.install((Module)new H2DataSourceModule(this.name, this.propertiesBase == null ? null : this.propertiesBase + "/jdbi.properties", new String[0]).withConfiguration(this.jdbiConfig.get()));
        this.install((Module)new H2SequenceServiceModule(this.name, this.propertiesBase == null ? null : this.propertiesBase + "/sequence.properties").withConfiguration(this.sequenceConfig.get()));
        this.install((Module)new SimpleJournalStoreModule(this.name, this.propertiesBase == null ? null : this.propertiesBase + "/keyvalue.properties").withConfiguration(this.keyValueConfig.get()));
    }
}

