/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Provider;
import io.kazuki.v0.internal.helper.EncodingHelper;
import io.kazuki.v0.internal.helper.LogTranslation;
import io.kazuki.v0.internal.helper.ResourceHelper;
import io.kazuki.v0.internal.helper.StringHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ConfigurationProvider<T>
implements Provider<T> {
    private final Logger log = LogTranslation.getLogger(this.getClass());
    private final String propertyPrefix;
    private final Class<T> configClass;
    private final String propertiesPath;
    private final boolean includeSystemProperties;

    public ConfigurationProvider(String string, Class<T> clazz) {
        this(string, clazz, null, true);
    }

    public ConfigurationProvider(String string, Class<T> clazz, @Nullable String string2, boolean bl) {
        Preconditions.checkNotNull((Object)string, (Object)"propertyPrefix");
        Preconditions.checkNotNull((Object)string, (Object)"configClass");
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        this.propertyPrefix = string;
        this.configClass = clazz;
        this.propertiesPath = string2;
        this.includeSystemProperties = bl;
    }

    public T get() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (this.propertiesPath != null) {
            this.log.debug("Loading classpath properties for {} from {}", (Object)this.configClass.getName(), (Object)this.propertiesPath);
            this.addProperties(ResourceHelper.loadProperties(this.propertiesPath), linkedHashMap);
        }
        if (this.includeSystemProperties) {
            this.log.debug("Loading system properties for {}", (Object)this.configClass.getName());
            this.addProperties(System.getProperties(), linkedHashMap);
        }
        if (linkedHashMap.isEmpty()) {
            throw new IllegalArgumentException("unable to configure instance - no properties set");
        }
        try {
            this.log.debug("Instantiating new {} from properties", (Object)this.configClass.getName());
            return EncodingHelper.asValue(linkedHashMap, this.configClass);
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    private void addProperties(Properties properties, Map<String, Object> map) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            if (!string.startsWith(this.propertyPrefix)) continue;
            String string2 = string.substring(this.propertyPrefix.length());
            String string3 = StringHelper.toCamelCase(string2);
            map.put(string3, (String)entry.getValue());
        }
    }
}

