/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema.types;

import io.kazuki.v0.internal.v2schema.Transform;
import io.kazuki.v0.internal.v2schema.types.TransformException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class UTCDateTransform
implements Transform<Object, Number> {
    private final DateTimeFormatter format = ISODateTimeFormat.basicDateTimeNoMillis();

    @Override
    public Long pack(Object object) throws TransformException {
        if (object == null) {
            throw new TransformException("must not be null");
        }
        try {
            String string = object instanceof DateTime ? this.format.print((ReadableInstant)((DateTime)object)) : object.toString();
            return this.format.parseMillis(string) / 1000L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TransformException("is not ISO8601 datetime (yyyyMMdd'T'HHmmssZ)");
        }
    }

    @Override
    public Object unpack(Number number) throws TransformException {
        if (number == null) {
            throw new TransformException("must not be null");
        }
        return this.format.print((ReadableInstant)new DateTime(number.longValue() * 1000L, DateTimeZone.UTC));
    }
}

