/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema.compact;

import io.kazuki.v0.internal.v2schema.Attribute;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.internal.v2schema.Transform;
import io.kazuki.v0.internal.v2schema.util.BitSetUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.dsig.TransformException;

public class StructureTransform
implements Transform<Map<String, Object>, List<Object>> {
    private final Schema schema;

    public StructureTransform(Schema schema) {
        this.schema = schema;
    }

    @Override
    public List<Object> pack(Map<String, Object> map) throws TransformException {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.putAll(map);
        BitSet bitSet = new BitSet();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        for (Attribute attribute : this.schema.getAttributes()) {
            if (linkedHashMap.containsKey(attribute.getName())) {
                arrayList.add(linkedHashMap.get(attribute.getName()));
                bitSet.set(n);
                linkedHashMap.remove(attribute.getName());
            }
            ++n;
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(BitSetUtil.pack(bitSet));
        arrayList2.add(arrayList);
        if (!linkedHashMap.isEmpty()) {
            arrayList2.add(linkedHashMap);
        }
        return arrayList2;
    }

    @Override
    public Map<String, Object> unpack(List<Object> list) throws TransformException {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (list.size() < 2) {
            throw new IllegalArgumentException("packed representation must contain at least 2 elements");
        }
        BitSet bitSet = BitSetUtil.unpack(list.get(0));
        List list2 = (List)list.get(1);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        int n = 0;
        int n2 = 0;
        for (Attribute attribute : this.schema.getAttributes()) {
            if (bitSet.get(n)) {
                linkedHashMap.put(attribute.getName(), list2.get(n2));
                ++n2;
            }
            ++n;
        }
        if (list.size() > 2) {
            Map map = (Map)list.get(2);
            linkedHashMap.putAll(map);
        }
        return linkedHashMap;
    }
}

