/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.v2schema;

import io.kazuki.v0.internal.v2schema.Attribute;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.internal.v2schema.types.TransformException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class SchemaValidator {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");

    public static void validate(Schema schema) throws TransformException {
        for (Attribute attribute : schema.getAttributes()) {
            SchemaValidator.validateAttribute(attribute);
        }
    }

    public static void validateUpgrade(Schema schema, Schema schema2) {
        for (Attribute attribute : schema.getAttributes()) {
            Attribute attribute2 = schema2.getAttribute(attribute.getName());
            SchemaValidator.validateAttributeUpgrade(attribute, attribute2);
        }
    }

    public static void validateAttribute(Attribute attribute) {
        List<String> list;
        String string = attribute.getName();
        if (!VALID_NAME_PATTERN.matcher(string).matches()) {
            throw new TransformException("Invalid attribute name : " + string);
        }
        if (attribute.getType().equals((Object)Attribute.Type.ENUM) && ((list = attribute.getValues()) == null || list.size() < 1)) {
            throw new TransformException("Invalid enum attribute (contains no values) : " + string);
        }
    }

    public static void validateAttributeUpgrade(Attribute attribute, Attribute attribute2) {
        String string = attribute.getName();
        Attribute.Type type = attribute.getType();
        Attribute.Type type2 = attribute2 == null ? null : attribute2.getType();
        switch (type) {
            case ANY: 
            case ARRAY: 
            case MAP: 
            case BOOLEAN: 
            case CHAR_ONE: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, type);
                break;
            }
            case ENUM: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, Attribute.Type.ENUM);
                SchemaValidator.assertEnumAttributeCompatible(attribute, attribute2);
                break;
            }
            case I8: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.I8, Attribute.Type.I16, Attribute.Type.I32, Attribute.Type.I64);
                break;
            }
            case I16: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.I16, Attribute.Type.I32, Attribute.Type.I64);
                break;
            }
            case I32: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.I32, Attribute.Type.I64);
                break;
            }
            case I64: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.I64);
                break;
            }
            case U8: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.U8, Attribute.Type.U16, Attribute.Type.U32, Attribute.Type.U64);
                break;
            }
            case U16: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.U16, Attribute.Type.U32, Attribute.Type.U64);
                break;
            }
            case U32: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.U32, Attribute.Type.U64);
                break;
            }
            case U64: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.U64);
                break;
            }
            case UTC_DATE_SECS: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.UTC_DATE_SECS, Attribute.Type.I64);
                break;
            }
            case UTF8_SMALLSTRING: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.UTF8_SMALLSTRING, Attribute.Type.UTF8_TEXT);
                break;
            }
            case UTF8_TEXT: {
                SchemaValidator.assertAttributeTypeOneOf(string, type2, null, Attribute.Type.UTF8_TEXT);
            }
        }
    }

    public static void assertEnumAttributeCompatible(Attribute attribute, Attribute attribute2) {
        if (attribute2 == null) {
            throw new TransformException("enum attributes, such as '" + attribute + "' may not be removed");
        }
        List<String> list = attribute2.getValues();
        List<String> list2 = attribute.getValues();
        if (list == null || list2 == null) {
            throw new TransformException("enum attribute '" + attribute.getName() + "' has no values");
        }
        if (list.size() < list2.size()) {
            throw new TransformException("may not remove enum values from '" + attribute.getName() + "', " + list + " has fewer items than " + list2);
        }
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i).equals(list.get(i))) continue;
            throw new TransformException("illegal enum values update for '" + attribute.getName() + "', " + list + " updates in the front or middle of " + list2);
        }
    }

    public static void assertAttributeTypeOneOf(String string, Attribute.Type type, Attribute.Type ... typeArray) {
        for (Attribute.Type type2 : typeArray) {
            if (type == null && type2 == null) {
                return;
            }
            if (type == null || !type.equals((Object)type2)) continue;
            return;
        }
        throw new TransformException("attribute '" + string + "' updated to '" + (Object)((Object)type) + "', must be one of " + Arrays.asList(typeArray));
    }
}

