/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.serialize.smile;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import io.kazuki.v0.internal.serialize.SerializationException;
import io.kazuki.v0.internal.serialize.Serializer;

public class SmileCodec<T>
implements Serializer<T> {
    private final SmileFactory smile = new SmileFactory();
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)this.smile);
    private final Class<T> theClass;

    public SmileCodec(Class<T> clazz) {
        this.theClass = clazz;
    }

    @Override
    public T decode(byte[] byArray) throws SerializationException {
        try {
            return (T)this.mapper.readValue(byArray, this.theClass);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    @Override
    public byte[] encode(Object object) throws SerializationException {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }
}

