/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTranslation {
    private static final boolean CHATTY = Boolean.parseBoolean(System.getProperty("io.kazuki.log-level-chatty", "false"));

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return !CHATTY ? logger : new LoggerProxy(logger, CHATTY).asProxyInstance();
    }

    public static Logger getLogger(String string) {
        Logger logger = LoggerFactory.getLogger((String)string);
        return !CHATTY ? logger : new LoggerProxy(logger, CHATTY).asProxyInstance();
    }

    public static class LoggerProxy
    implements InvocationHandler {
        private final Class<Logger> iface = Logger.class;
        private final boolean chatty;
        private final Logger delegate;
        private final InvocationHandler finalHandler;
        final InvocationHandler UNSUPPORTED_OPERATION_HANDLER = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                throw new UnsupportedOperationException();
            }
        };

        public LoggerProxy(Logger logger, boolean bl) {
            this.delegate = logger;
            this.finalHandler = this.UNSUPPORTED_OPERATION_HANDLER;
            this.chatty = bl;
        }

        public Logger asProxyInstance() {
            return (Logger)Proxy.newProxyInstance(this.iface.getClassLoader(), new Class[]{this.iface}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Class<?>[] classArray;
            String string = method.getName();
            if (this.iface.getMethod(string, classArray = method.getParameterTypes()) == null) {
                return this.finalHandler.invoke(object, method, objectArray);
            }
            try {
                String string2;
                boolean bl = "INFO".equals(string);
                if (!this.chatty || !bl) {
                    return this.delegate.getClass().getMethod(string, classArray).invoke((Object)this.delegate, objectArray);
                }
                switch (string) {
                    case "debug": {
                        string2 = "info";
                        break;
                    }
                    case "trace": {
                        string2 = "debug";
                        break;
                    }
                    default: {
                        string2 = string;
                    }
                }
                return this.delegate.getClass().getMethod(string2, classArray).invoke((Object)this.delegate, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            return this.finalHandler.invoke(object, method, objectArray);
        }
    }
}

