/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.helper;

import com.google.common.base.Throwables;
import io.kazuki.v0.internal.helper.Hex;
import io.kazuki.v0.store.Key;
import io.kazuki.v0.store.sequence.KeyImpl;
import java.nio.ByteBuffer;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyObfuscator {
    private static final String keyString = System.getProperty("key.encrypt.password", "changeme");
    private static final byte[] saltBytes = System.getProperty("key.encrypt.salt", "asalt").getBytes();
    private static final byte[] ivBytes;
    private static final Cipher cipher;
    private static final AlgorithmParameterSpec paramSpec;
    private static ConcurrentHashMap<String, SecretKey> keyCache;

    public static synchronized String encrypt(String string, Long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@");
        stringBuilder.append(string);
        stringBuilder.append(":");
        try {
            byte[] byArray = ByteBuffer.allocate(8).putLong(l).array();
            cipher.init(1, (java.security.Key)KeyObfuscator.getKey(string), paramSpec);
            byte[] byArray2 = cipher.doFinal(byArray);
            stringBuilder.append(Hex.encodeHex(byArray2));
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    public static synchronized Key decrypt(String string) {
        if (string == null || string.length() == 0 || !string.contains(":")) {
            throw new IllegalArgumentException("Invalid key");
        }
        if (!string.startsWith("@")) {
            return KeyImpl.valueOf(string);
        }
        String[] stringArray = string.substring(1).split(":");
        if (stringArray.length != 2 || stringArray[1].length() != 16) {
            throw new IllegalArgumentException("Invalid key");
        }
        String string2 = stringArray[0];
        try {
            byte[] byArray = Hex.decodeHex(stringArray[1].toCharArray());
            cipher.init(2, (java.security.Key)KeyObfuscator.getKey(string2), paramSpec);
            byte[] byArray2 = cipher.doFinal(byArray);
            Long l = ByteBuffer.allocate(8).put(byArray2).getLong(0);
            return KeyImpl.createInternal(string2, l);
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    private static SecretKey getKey(String string) throws Exception {
        if (!keyCache.containsKey(string)) {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            String string2 = keyString + ":" + string;
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string2.toCharArray(), saltBytes, 1024, 64);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "DES");
            keyCache.put(string, secretKeySpec);
        }
        return keyCache.get(string);
    }

    static {
        try {
            ivBytes = Hex.decodeHex(System.getProperty("key.encrypt.iv", "0123456789ABCDEF").toCharArray());
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
        paramSpec = new IvParameterSpec(ivBytes);
        keyCache = new ConcurrentHashMap();
    }
}

