/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.helper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import io.kazuki.v0.store.KazukiException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class EncodingHelper {
    private static final SmileFactory smileFactory = new SmileFactory();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String convertToJson(T t) throws Exception {
        return mapper.writeValueAsString(t);
    }

    public static <T> Map<String, Object> asJsonMap(T t) throws Exception {
        return (Map)mapper.convertValue(t, LinkedHashMap.class);
    }

    public static <T> T asValue(Map<String, Object> map, Class<T> clazz) throws Exception {
        return (T)mapper.convertValue(map, clazz);
    }

    public static Map<String, Object> parseJsonString(String string) throws Exception {
        if (string == null || string.length() == 0 || string.equals("null")) {
            throw new KazukiException("Invalid entity 'value'");
        }
        Object object = mapper.readValue(string, LinkedHashMap.class);
        if (!(object instanceof Map)) {
            throw new KazukiException("Invalid entity 'value'");
        }
        return (Map)object;
    }

    public static byte[] convertToSmile(Object object) throws KazukiException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SmileGenerator smileGenerator = smileFactory.createGenerator((OutputStream)byteArrayOutputStream);
            mapper.writeValue((JsonGenerator)smileGenerator, object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw new KazukiException(exception);
        }
    }

    public static <T> T parseSmile(byte[] byArray, Class<T> clazz) throws KazukiException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SmileParser smileParser = smileFactory.createParser((InputStream)byteArrayInputStream);
            return (T)mapper.readValue((JsonParser)smileParser, clazz);
        }
        catch (Exception exception) {
            throw new KazukiException(exception);
        }
    }
}

