/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.internal.availability;

import com.google.common.base.Throwables;
import io.kazuki.v0.internal.availability.Releasable;
import io.kazuki.v0.internal.helper.LogTranslation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class AvailabilityManager
implements Releasable {
    private final Logger log = LogTranslation.getLogger(this.getClass());
    private final AtomicBoolean available = new AtomicBoolean();

    public <T> T doProtected(ProtectedCommand<T> protectedCommand) {
        this.log.debug("Executing protected command: {}", protectedCommand);
        boolean bl = this.available.compareAndSet(true, false);
        try {
            if (bl) {
                T t = protectedCommand.execute(this);
                this.log.debug("Executed protected command: {}", protectedCommand);
                return t;
            }
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
        throw new IllegalStateException("service unavailable");
    }

    public void assertAvailable() {
        if (!this.available.get()) {
            throw new IllegalStateException("service unavailable");
        }
    }

    public void setAvailable(boolean bl) {
        this.log.trace("Setting availability status to {}", (Object)bl);
        this.available.set(bl);
    }

    public boolean isAvailable() {
        return this.available.get();
    }

    @Override
    public boolean release() {
        this.log.trace("Releasing availability manager flag");
        return this.available.compareAndSet(false, true);
    }

    public static interface ProtectedCommand<T> {
        public T execute(Releasable var1) throws Exception;
    }
}

